/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddressList;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.RichTextString;

public class ExportExcel {
    private HSSFWorkbook wb = new HSSFWorkbook();
    private HSSFSheet sheet = null;
    private HSSFDataFormat format = null;
    private HSSFRow hdRow = null;
    int listlength = 0;
    int s = 1;

    public void createSheet(String sheetName) {
        this.sheet = this.wb.createSheet(sheetName);
        this.format = this.wb.createDataFormat();
        this.hdRow = this.sheet.createRow(0);
    }

    public void addHeader(List<String> rowvalues, boolean isFilter) throws Exception {
        this.listlength = rowvalues.size();
        HSSFFont workFont = this.wb.createFont();
        workFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        workFont.setFontHeightInPoints((short)14);
        workFont.setBoldweight((short)700);
        HSSFCellStyle hdStyle = this.wb.createCellStyle();
        hdStyle.setBorderBottom((short)1);
        hdStyle.setBottomBorderColor((short)8);
        hdStyle.setBorderLeft((short)1);
        hdStyle.setLeftBorderColor((short)8);
        hdStyle.setBorderRight((short)1);
        hdStyle.setRightBorderColor((short)8);
        hdStyle.setBorderTop((short)1);
        hdStyle.setTopBorderColor((short)8);
        hdStyle.setAlignment((short)2);
        hdStyle.setFillForegroundColor((short)22);
        hdStyle.setFillPattern((short)1);
        hdStyle.setBorderBottom((short)1);
        hdStyle.setFont(workFont);
        int i = 0;
        for (String title : rowvalues) {
            HSSFCell cell1 = this.hdRow.createCell(i++);
            HSSFRichTextString value = new HSSFRichTextString(title);
            cell1.setCellValue((RichTextString)value);
            if (!isFilter) continue;
            cell1.setCellStyle(hdStyle);
        }
    }

    public void addRow(List rowvalues) {
        HSSFRow dtRow = this.sheet.createRow(this.s++);
        HSSFDataFormat format = this.wb.createDataFormat();
        HSSFCellStyle dtStyle = this.wb.createCellStyle();
        dtStyle.setDataFormat(format.getFormat("text"));
        dtStyle.setBorderBottom((short)1);
        dtStyle.setBottomBorderColor((short)8);
        dtStyle.setBorderLeft((short)1);
        dtStyle.setLeftBorderColor((short)8);
        dtStyle.setBorderRight((short)1);
        dtStyle.setRightBorderColor((short)8);
        dtStyle.setBorderTop((short)1);
        dtStyle.setTopBorderColor((short)8);
        dtStyle.setFillForegroundColor((short)43);
        HSSFCellStyle dateStyle = this.wb.createCellStyle();
        dateStyle.setDataFormat(format.getFormat("yyyy-m-d"));
        dateStyle.setBorderBottom((short)1);
        dateStyle.setBottomBorderColor((short)8);
        dateStyle.setBorderLeft((short)1);
        dateStyle.setLeftBorderColor((short)8);
        dateStyle.setBorderRight((short)1);
        dateStyle.setRightBorderColor((short)8);
        dateStyle.setBorderTop((short)1);
        dateStyle.setTopBorderColor((short)8);
        dateStyle.setFillForegroundColor((short)43);
        for (int j = 0; j < rowvalues.size(); ++j) {
            String flag = "";
            Object cell_data = rowvalues.get(j);
            HSSFCell cell = dtRow.createCell(j);
            if (cell_data instanceof String) {
                flag = "string";
                cell.setCellValue((String)cell_data);
            } else if (cell_data instanceof Double) {
                cell.setCellValue(((Double)cell_data).doubleValue());
            } else if (cell_data instanceof Integer) {
                cell.setCellValue(Double.valueOf(String.valueOf(cell_data)).doubleValue());
            } else if (cell_data instanceof Date) {
                flag = "date";
                cell.setCellValue((Date)cell_data);
            } else if (cell_data instanceof Boolean) {
                cell.setCellValue(((Boolean)cell_data).booleanValue());
            } else if (cell_data instanceof Float) {
                cell.setCellValue((double)((Float)cell_data).floatValue());
            }
            if (flag == "" || flag.equals("string")) {
                cell.setCellStyle(dtStyle);
                continue;
            }
            if (!flag.equals("date")) continue;
            cell.setCellStyle(dateStyle);
        }
    }

    public void insertRow(List rowvalues, int row) {
        this.sheet.shiftRows(row, this.sheet.getLastRowNum(), 1);
        HSSFRow dtRow = this.sheet.createRow(row);
        HSSFCellStyle dtStyle = this.wb.createCellStyle();
        dtStyle.setBorderBottom((short)1);
        dtStyle.setBottomBorderColor((short)8);
        dtStyle.setBorderLeft((short)1);
        dtStyle.setLeftBorderColor((short)8);
        dtStyle.setBorderRight((short)1);
        dtStyle.setRightBorderColor((short)8);
        dtStyle.setBorderTop((short)1);
        dtStyle.setTopBorderColor((short)8);
        dtStyle.setFillForegroundColor((short)43);
        HSSFDataFormat format = this.wb.createDataFormat();
        Short str = format.getFormat("text");
        Short date = format.getFormat("yyyy-m-d");
        for (int j = 0; j < rowvalues.size(); ++j) {
            Object cell_data = rowvalues.get(j);
            HSSFCell cell = dtRow.createCell(j);
            if (cell_data instanceof String) {
                dtStyle.setDataFormat(str.shortValue());
                cell.setCellValue((String)cell_data);
            } else if (cell_data instanceof Double) {
                cell.setCellValue(((Double)cell_data).doubleValue());
            } else if (cell_data instanceof Integer) {
                cell.setCellValue(Double.valueOf(String.valueOf(cell_data)).doubleValue());
            } else if (cell_data instanceof Date) {
                dtStyle.setDataFormat(date.shortValue());
                cell.setCellValue((Date)cell_data);
            } else if (cell_data instanceof Boolean) {
                cell.setCellValue(((Boolean)cell_data).booleanValue());
            } else if (cell_data instanceof Float) {
                cell.setCellValue((double)((Float)cell_data).floatValue());
            }
            cell.setCellStyle(dtStyle);
        }
    }

    public void delRow(int row) {
        if (row > 0) {
            try {
                this.sheet.shiftRows(row, this.sheet.getLastRowNum(), -1);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                System.out.println("error");
            }
        } else {
            System.out.println("\u9519\u8bef\u7684");
        }
    }

    public void setSelect(int row, int cells, List cellvalue) {
        String[] str = new String[cellvalue.size()];
        for (int i = 0; i < cellvalue.size(); ++i) {
            str[i] = (String)cellvalue.get(i);
        }
        this.setHSSFValidation(this.sheet, str, row, 65535, cells, cells);
    }

    private void setHSSFValidation(HSSFSheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
        DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])textlist);
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        HSSFDataValidation data_validation_list = new HSSFDataValidation((org.apache.poi.ss.util.CellRangeAddressList)regions, (DataValidationConstraint)constraint);
        sheet.addValidationData((DataValidation)data_validation_list);
    }

    private void setHSSFPrompt(HSSFSheet sheet, String promptTitle, String promptContent, int firstRow, int endRow, int firstCol, int endCol) {
        DVConstraint constraint = DVConstraint.createCustomFormulaConstraint((String)"BB1");
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        HSSFDataValidation data_validation_view = new HSSFDataValidation((org.apache.poi.ss.util.CellRangeAddressList)regions, (DataValidationConstraint)constraint);
        data_validation_view.createPromptBox(promptTitle, promptContent);
        sheet.addValidationData((DataValidation)data_validation_view);
    }

    public void exportExcel(String file) throws Exception {
        FileOutputStream fileOut = new FileOutputStream(file);
        this.wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    public void exportExcel(File file) throws Exception {
        FileOutputStream fileOut = new FileOutputStream(file);
        this.wb.write((OutputStream)fileOut);
        fileOut.close();
    }

    public void exportExcel(OutputStream outputstream) throws Exception {
        BufferedOutputStream buffout = new BufferedOutputStream(outputstream);
        this.wb.write((OutputStream)buffout);
        buffout.flush();
        buffout.close();
    }

    public static Object getCellValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        cell.setCellType(1);
        return cell.getStringCellValue();
    }

    public static void main(String[] args) throws Exception {
        String roleids = "1,2";
        Long roleId = 3L;
        System.out.println("contains=" + roleids.contains(String.valueOf(roleId)));
    }

    public HSSFWorkbook getWb() {
        return this.wb;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public HSSFDataFormat getFormat() {
        return this.format;
    }

    public HSSFRow getHdRow() {
        return this.hdRow;
    }

    public int getListlength() {
        return this.listlength;
    }

    public int getS() {
        return this.s;
    }

    public void setWb(HSSFWorkbook wb) {
        this.wb = wb;
    }

    public void setSheet(HSSFSheet sheet) {
        this.sheet = sheet;
    }

    public void setFormat(HSSFDataFormat format) {
        this.format = format;
    }

    public void setHdRow(HSSFRow hdRow) {
        this.hdRow = hdRow;
    }

    public void setListlength(int listlength) {
        this.listlength = listlength;
    }

    public void setS(int s) {
        this.s = s;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportExcel)) {
            return false;
        }
        ExportExcel other = (ExportExcel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HSSFWorkbook this$wb = this.getWb();
        HSSFWorkbook other$wb = other.getWb();
        if (this$wb == null ? other$wb != null : !this$wb.equals(other$wb)) {
            return false;
        }
        HSSFSheet this$sheet = this.getSheet();
        HSSFSheet other$sheet = other.getSheet();
        if (this$sheet == null ? other$sheet != null : !this$sheet.equals(other$sheet)) {
            return false;
        }
        HSSFDataFormat this$format = this.getFormat();
        HSSFDataFormat other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        HSSFRow this$hdRow = this.getHdRow();
        HSSFRow other$hdRow = other.getHdRow();
        if (this$hdRow == null ? other$hdRow != null : !this$hdRow.equals(other$hdRow)) {
            return false;
        }
        if (this.getListlength() != other.getListlength()) {
            return false;
        }
        return this.getS() == other.getS();
    }

    public boolean canEqual(Object other) {
        return other instanceof ExportExcel;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        HSSFWorkbook $wb = this.getWb();
        result = result * 31 + ($wb == null ? 0 : $wb.hashCode());
        HSSFSheet $sheet = this.getSheet();
        result = result * 31 + ($sheet == null ? 0 : $sheet.hashCode());
        HSSFDataFormat $format = this.getFormat();
        result = result * 31 + ($format == null ? 0 : $format.hashCode());
        HSSFRow $hdRow = this.getHdRow();
        result = result * 31 + ($hdRow == null ? 0 : $hdRow.hashCode());
        result = result * 31 + this.getListlength();
        result = result * 31 + this.getS();
        return result;
    }

    public String toString() {
        return "ExportExcel(wb=" + this.getWb() + ", sheet=" + this.getSheet() + ", format=" + this.getFormat() + ", hdRow=" + this.getHdRow() + ", listlength=" + this.getListlength() + ", s=" + this.getS() + ")";
    }
}

