/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.util;

import edu.ecompus.cas.module.so.AddressIpSO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.json.JSONObject;

public class AddressUtils {
    public static AddressIpSO GetAddressByTaobao(String IP) {
        AddressIpSO ipso = new AddressIpSO();
        try {
            String str = AddressUtils.getJsonContent("http://ip.taobao.com/service/getIpInfo.php?ip=" + IP);
            JSONObject obj = JSONObject.fromObject((Object)str);
            JSONObject obj2 = (JSONObject)obj.get("data");
            String code = String.valueOf(obj.get("code"));
            ipso.setIp(IP);
            if (code.equals("0")) {
                ipso.setArea(String.valueOf(obj2.get("area")));
                ipso.setArea_id(String.valueOf(obj2.get("area_id")));
                ipso.setCity(String.valueOf(obj2.get("city")));
                ipso.setCity_id(String.valueOf(obj2.get("city_id")));
                ipso.setCountry(String.valueOf(obj2.get("country")));
                ipso.setCountry_id(String.valueOf(obj2.get("country_id")));
                ipso.setCounty(String.valueOf(obj2.get("county")));
                ipso.setCounty_id(String.valueOf(obj2.get("county_id")));
                ipso.setIsp(String.valueOf(obj2.get("isp")));
                ipso.setIsp_id(String.valueOf(obj2.get("isp_id")));
                ipso.setRegion(String.valueOf(obj2.get("region")));
                ipso.setRegion_id(String.valueOf(obj2.get("region_id")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipso;
    }

    public static AddressIpSO GetAddressBySina(String IP) {
        AddressIpSO ipso = new AddressIpSO();
        try {
            String str = AddressUtils.getJsonContent("http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=json&ip=" + IP);
            JSONObject obj = JSONObject.fromObject((Object)str);
            String code = String.valueOf(obj.get("ret"));
            ipso.setIp(IP);
            if (code.equals("1")) {
                ipso.setCountry(String.valueOf(obj.get("country")));
                ipso.setRegion(String.valueOf(obj.get("province")));
                ipso.setCity(String.valueOf(obj.get("city")));
                ipso.setArea(String.valueOf(obj.get("district")));
                ipso.setIsp(String.valueOf(obj.get("isp")));
                ipso.setType(String.valueOf(obj.get("type")));
                ipso.setDesc(String.valueOf(obj.get("desc")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipso;
    }

    public static String getJsonContent(String urlStr) {
        try {
            URL url = new URL(urlStr);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setConnectTimeout(3000);
            httpConn.setDoInput(true);
            httpConn.setRequestMethod("GET");
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                return AddressUtils.ConvertStream2Json(httpConn.getInputStream());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String ConvertStream2Json(InputStream inputStream) {
        String jsonStr = "";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        try {
            while ((len = inputStream.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, len);
            }
            jsonStr = new String(out.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonStr;
    }

    public static void main(String[] args) {
        System.out.println(AddressUtils.GetAddressByTaobao("125.70.11.136"));
        System.out.println(AddressUtils.GetAddressBySina("125.120.156.225"));
    }
}

