/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.service.impl;

import edu.ecompus.cas.dao.UserDAO;
import edu.ecompus.cas.dao.UserLoginLogDAO;
import edu.ecompus.cas.dao.UserRoleDAO;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserLoginLog;
import edu.ecompus.cas.entity.UserRole;
import edu.ecompus.cas.service.UserService;
import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class UserServiceImpl
extends GenerateService
implements UserService {
    @Autowired
    UserDAO userDAO;
    @Autowired
    UserLoginLogDAO userLoginLogDAO;
    @Autowired
    UserRoleDAO userRoleDao;

    @Override
    @CachePut(value={"default"}, key="'usercachebykey_un' + #user.username")
    public User addUser(User user) {
        if (user != null) {
            this.userDAO.create(user);
            return user;
        }
        return null;
    }

    @Override
    public User getUser(String userName, String nickName) {
        if (userName != null && !"".equals(userName)) {
            return this.userDAO.getUser(userName);
        }
        if (nickName != null && !"".equals(nickName)) {
            return this.userDAO.getUserByNickName(nickName);
        }
        return null;
    }

    @Override
    @Cacheable(value={"default"}, key="'usercachebykey_un' + #userName")
    public User getUserByUserName(String userName) {
        if (userName != null && !"".equals(userName)) {
            return this.userDAO.getUser(userName);
        }
        return null;
    }

    @Override
    public User getUserByUserNameNoCache(String userName) {
        if (userName != null && !"".equals(userName)) {
            return this.userDAO.getUser(userName);
        }
        return null;
    }

    @Override
    @CacheEvict(value={"default"}, key="'usercachebykey_un' + #userName")
    public void clearUserByUserNameCache(String userName) {
    }

    @Override
    @CacheEvict(value={"default"}, key="'usercachebykey_' + #userId")
    public void clearUserByUserIdCache(long userId) {
    }

    @Override
    @Cacheable(value={"default"}, key="'usercachebykey_' + #userId")
    public User getUserByUserId(Long userId) {
        if (userId != null) {
            return this.userDAO.queryUserById(userId);
        }
        return null;
    }

    @Override
    public List<User> getUserList(String username, int enable, Page page) {
        return this.userDAO.queryUserList(username, null, enable, null, null, page);
    }

    @Override
    public List<User> getUserListInCommonUser(String keyword, int enabled, Page page) {
        return this.userDAO.queryUserListInCommonUser(keyword, enabled, page);
    }

    @Override
    @CacheEvict(value={"default"}, key="'usercachebykey_' + #user.id")
    public void updateUser(User user) {
        this.userDAO.update(user);
    }

    @Override
    @Cacheable(value={"default"}, key="'UserLoginCount-cache-by-user' + #userId")
    public Long countLogin(Long userId) {
        return this.userLoginLogDAO.countLogin(userId);
    }

    @Override
    @Cacheable(value={"default"}, key="'UserRoleList-cache-by-user' + #user.id")
    public List<UserRole> getUserRoleList(User user) {
        if (user == null) {
            return Collections.emptyList();
        }
        return this.userRoleDao.queryUserRoleList(user.getId());
    }

    @Override
    public UserLoginLog addUserLoginLog(UserLoginLog userLoginLog) {
        this.userLoginLogDAO.create(userLoginLog);
        return userLoginLog;
    }

    @Override
    public void AddUserLoginLog(String ip, Long userId) {
        UserLoginLog log = new UserLoginLog();
        log.setLoginDate(new Date());
        log.setLoginIp(ip);
        log.setUserId(userId);
        this.addUserLoginLog(log);
    }

    @Override
    public List<User> getUserByIds(String ids) {
        if (ids == null || "".equals(ids)) {
            return Collections.emptyList();
        }
        return this.userDAO.queryUserByIds(ids);
    }

    @Override
    public List<User> getUserList(int type, Long schoolId) {
        if (type == -1 || schoolId == null || schoolId <= 0L) {
            return Collections.emptyList();
        }
        return this.userDAO.queryUserListBySchool(type, schoolId);
    }

    @Override
    public User getUserByNickName(String nickName) {
        if (nickName != null && !"".equals(nickName)) {
            return this.userDAO.getUserByNickName(nickName);
        }
        return null;
    }

    @Override
    public List<User> getUserList(String keyword, Long schoolId, int enabled, String mobile, String identity, Page page) {
        return this.userDAO.queryUserList(keyword, schoolId, enabled, mobile, identity, page);
    }
}

