/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.service.impl;

import edu.ecompus.cas.dao.CompanyDAO;
import edu.ecompus.cas.dao.CompanyRegDAO;
import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.CompanyReg;
import edu.ecompus.cas.service.CompanyService;
import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="companyService")
public class CompanyServiceImpl
extends GenerateService
implements CompanyService {
    @Autowired
    CompanyDAO companyDAO;
    @Autowired
    CompanyRegDAO companyRegDAO;

    @Override
    public List<Company> getCompanyList() {
        return this.companyDAO.queryCompanyList();
    }

    @Override
    public void creatCompany(Company company) {
        if (company != null) {
            this.companyDAO.create(company);
        }
    }

    @Override
    public Company getCompanyById(Long id) {
        return (Company)this.companyDAO.query(id);
    }

    @Override
    @Cacheable(value={"default"}, key="'company-cache-by' + #companyId")
    public Company getCompany(Long companyId) {
        if (companyId != null && companyId > 0L) {
            return (Company)this.companyDAO.query(companyId);
        }
        return null;
    }

    @Override
    @CacheEvict(value={"default"}, key="'company-cache-by' + #company.id")
    public void updateCompany(Company company) {
        if (company != null) {
            this.companyDAO.update(company);
        }
    }

    @Override
    @Cacheable(value={"default"}, key="'CompanyList-cache-State0'")
    public List<Company> getCompanyListByState0() {
        return this.companyDAO.queryCompanyListByKey(null, 0, null, null, null, null);
    }

    @Override
    @CacheEvict(value={"default"}, key="'CompanyList-cache-State0'")
    public void clearCompanyListByState0Cache() {
    }

    @Override
    public List<Company> getCompanyListByKey(String companyName, int status, String province, String city, String area, Page page) {
        return this.companyDAO.queryCompanyListByKey(companyName, status, province, city, area, page);
    }

    @Override
    public List<Company> getCompanyList(String keyword, String district, int classify, int status, Page page) {
        return this.companyDAO.queryCompanyList(keyword, district, classify, status, page);
    }

    @Override
    public List<Company> getCompanyListBySystem(String keyword, int status, Page page) {
        return this.companyDAO.queryCompanyListBySystem(keyword, status, page);
    }

    @Override
    public CompanyReg addCompanyReg(CompanyReg companyReg) {
        this.companyRegDAO.create(companyReg);
        return companyReg;
    }

    @Override
    public void updateCompanyReg(CompanyReg companyReg) {
        this.companyRegDAO.update(companyReg);
    }

    @Override
    public void delCompanyReg(CompanyReg companyReg) {
        this.companyRegDAO.delete(companyReg);
    }

    @Override
    public List<CompanyReg> getCompanyRegList(String keyword, int type, String province, String city, Page page) {
        return this.companyRegDAO.queryCompanyRegList(keyword, type, province, city, page);
    }

    @Override
    public CompanyReg getCompanyRegById(Long id) {
        return (CompanyReg)this.companyRegDAO.query(id);
    }

    @Override
    public Company getExistsCompany(String companyName, String province, String city, String area) {
        List<Company> list = this.companyDAO.queryCompanyListByKey(companyName, -1, province, city, area, new Page(1, 1));
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}

