/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.service.impl;

import edu.ecompus.cas.dao.AppDAO;
import edu.ecompus.cas.dao.CompanyAppDAO;
import edu.ecompus.cas.dao.CompanyDAO;
import edu.ecompus.cas.dao.FeedbackDAO;
import edu.ecompus.cas.dao.UserAppDAO;
import edu.ecompus.cas.entity.App;
import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.CompanyApp;
import edu.ecompus.cas.entity.Feedback;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserApp;
import edu.ecompus.cas.service.AppService;
import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="appService")
public class AppServiceImpl
extends GenerateService
implements AppService {
    @Autowired
    AppDAO appDao;
    @Autowired
    CompanyAppDAO companyAppDAO;
    @Autowired
    UserAppDAO userAppDAO;
    @Autowired
    FeedbackDAO feedbackDAO;
    @Autowired
    CompanyDAO companyDao;

    @Override
    public CompanyApp getCompanyApp(Long id) {
        return (CompanyApp)this.companyAppDAO.query(id);
    }

    @Override
    @Cacheable(value={"default"}, key="'CompanyAppcachebyid_' + #id")
    public CompanyApp getCompanyAppById(Long id) {
        return (CompanyApp)this.companyAppDAO.query(id);
    }

    @Override
    public List<App> getAppList(Page page) {
        return this.appDao.queryAppList(page);
    }

    @Override
    public List<CompanyApp> getCompanyApp(Company school, int apptype, int state) {
        if (school == null) {
            return Collections.emptyList();
        }
        return this.companyAppDAO.queryCompanyApp(school.getId(), apptype, state);
    }

    @Override
    public List<UserApp> getUserApp(User user, Company school, int state) {
        if (user == null || school == null) {
            return Collections.emptyList();
        }
        return this.userAppDAO.queryUserApp(user, school, state);
    }

    @Override
    public List<CompanyApp> getWeiboAppList(User user) {
        if (user == null) {
            return Collections.emptyList();
        }
        if (user != null && user.getSchool_id() == null) {
            return Collections.emptyList();
        }
        Company school = (Company)this.companyDao.query(user.getSchool_id());
        ArrayList<CompanyApp> result = new ArrayList<CompanyApp>();
        List<CompanyApp> companyAppList = this.getCompanyApp(school, 1, 1);
        List<UserApp> userAppList = this.getUserApp(user, school, -1);
        for (CompanyApp cpp : companyAppList) {
            for (UserApp upp : userAppList) {
                if (upp.getState() == 2) continue;
                result.add(cpp);
            }
        }
        return result;
    }

    @Override
    public boolean isActivateApp(User user, CompanyApp cpp) {
        if (user == null || user.getSchool_id() != null || cpp == null) {
            return false;
        }
        Company school = (Company)this.companyDao.query(user.getSchool_id());
        Long count = this.userAppDAO.countActivateApp(user, cpp, school);
        return count > 0L;
    }

    @Override
    @Cacheable(value={"default"}, key="'WeiAppListbyschool_' + #school")
    public List<CompanyApp> getWeiAppList(Long school) {
        if (school != null && school > 0L) {
            return this.companyAppDAO.queryCompanyApp(school, 2, 1);
        }
        return Collections.emptyList();
    }

    @Override
    @CacheEvict(value={"default"}, key="'WeiAppListbyschool_' + #schoolId")
    public void clearWeiAppListCache(Long schoolId) {
    }

    @Override
    public List<CompanyApp> getWeiAppListNoCache(Long school) {
        if (school != null && school > 0L) {
            return this.companyAppDAO.queryCompanyApp(school, 2, 1);
        }
        return Collections.emptyList();
    }

    @Override
    public void activateApp(User user, CompanyApp cpp) {
        Company school = null;
        if (user != null && user.getSchool_id() > 0L) {
            school = (Company)this.companyDao.query(user.getSchool_id());
        }
        UserApp upp = new UserApp();
        upp.setCreateDate(new Date());
        upp.setSchool(school);
        upp.setSchoolApp(cpp);
        upp.setState(1);
        upp.setUser(user);
        this.userAppDAO.create(upp);
    }

    @Override
    @Cacheable(value={"default"}, key="'appcachebykey_' + #id")
    public App getAppById(Long id) {
        if (id > 0L) {
            return (App)this.appDao.query(id);
        }
        return null;
    }

    @Override
    @Cacheable(value={"default"}, key="'appcachebyclient_' + #clientId")
    public App getByClientId(String clientId) {
        if (clientId != null && !"".equals(clientId)) {
            return this.appDao.queryClientByClientId(clientId);
        }
        return null;
    }

    @Override
    @Cacheable(value={"default"}, key="'feedbackcachebykey_' + #id")
    public Feedback getFeedbackById(Long id) {
        if (id > 0L) {
            return (Feedback)this.feedbackDAO.query(id);
        }
        return null;
    }

    @Override
    @CacheEvict(value={"default"}, key="'feedbackcache'")
    public Feedback addFeedback(Feedback feedback) {
        if (feedback != null) {
            this.feedbackDAO.create(feedback);
            return feedback;
        }
        return null;
    }

    @Override
    public List<Feedback> getFeedbackList(Long appid, int status, Page page) {
        return this.feedbackDAO.queryFeedbackList(appid, status, page);
    }

    @Override
    @Cacheable(value={"default"}, key="'feedbackcache'")
    public List<Feedback> getFeedbackList(int status, Page page) {
        return this.feedbackDAO.queryFeedbackList(status, page);
    }

    @Override
    public Long countAppFeedback(Long appid, int status) {
        return this.feedbackDAO.countAppFeedback(appid, status);
    }
}

