/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.cache.memcached;

import edu.ecompus.cas.cache.memcached.MemcachedCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;

public class MemcachedCacheManager
extends AbstractCacheManager {
    private ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();
    private Map<String, Integer> expireMap = new HashMap<String, Integer>();

    protected Collection<? extends Cache> loadCaches() {
        Collection values = this.cacheMap.values();
        return values;
    }

    public void setCaches(Collection<? extends Cache> caches) {
        for (Cache cache : caches) {
            this.cacheMap.put(cache.getName(), cache);
        }
    }

    public Cache getCache(String name) {
        Cache cache = (Cache)this.cacheMap.get(name);
        if (cache == null) {
            Integer expire = this.expireMap.get(name);
            if (expire == null) {
                expire = 0;
                this.expireMap.put(name, expire);
            }
            cache = new MemcachedCache();
            this.cacheMap.put(name, cache);
        }
        return cache;
    }

    public void setConfigMap(Map<String, Integer> configMap) {
        this.expireMap = configMap;
    }
}

