/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.business;

import com.tencent.common.Configure;
import com.tencent.common.Log;
import com.tencent.common.Signature;
import com.tencent.common.Util;
import com.tencent.common.XMLParser;
import com.tencent.common.report.ReporterFactory;
import com.tencent.common.report.protocol.ReportReqData;
import com.tencent.common.report.service.ReportService;
import com.tencent.protocol.refund_query_protocol.RefundOrderData;
import com.tencent.protocol.refund_query_protocol.RefundQueryReqData;
import com.tencent.protocol.refund_query_protocol.RefundQueryResData;
import com.tencent.service.RefundQueryService;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class RefundQueryBusiness {
    private static Log log = new Log(LoggerFactory.getLogger(RefundQueryBusiness.class));
    private static String result = "";
    private static String orderListResult = "";
    private RefundQueryService refundQueryService = new RefundQueryService();

    public String getOrderListResult() {
        return orderListResult;
    }

    public void setOrderListResult(String orderListResult) {
        RefundQueryBusiness.orderListResult = orderListResult;
    }

    public void run(RefundQueryReqData refundQueryReqData, ResultListener resultListener) throws Exception {
        long costTimeStart = System.currentTimeMillis();
        log.i("\u9000\u6b3e\u67e5\u8be2API\u8fd4\u56de\u7684\u6570\u636e\u5982\u4e0b\uff1a");
        String refundQueryServiceResponseString = this.refundQueryService.request(refundQueryReqData);
        long costTimeEnd = System.currentTimeMillis();
        long totalTimeCost = costTimeEnd - costTimeStart;
        log.i("api\u8bf7\u6c42\u603b\u8017\u65f6\uff1a" + totalTimeCost + "ms");
        log.i(refundQueryServiceResponseString);
        RefundQueryResData refundQueryResData = (RefundQueryResData)Util.getObjectFromXML(refundQueryServiceResponseString, RefundQueryResData.class);
        ReportReqData reportReqData = new ReportReqData(refundQueryReqData.getDevice_info(), Configure.REFUND_QUERY_API, (int)totalTimeCost, refundQueryResData.getReturn_code(), refundQueryResData.getReturn_msg(), refundQueryResData.getResult_code(), refundQueryResData.getErr_code(), refundQueryResData.getErr_code_des(), refundQueryResData.getOut_trade_no(), Configure.getIP());
        if (Configure.isUseThreadToDoReport()) {
            ReporterFactory.getReporter(reportReqData).run();
            long timeAfterReport = System.currentTimeMillis();
            Util.log("pay+report\u603b\u8017\u65f6\uff08\u5f02\u6b65\u65b9\u5f0f\u4e0a\u62a5\uff09\uff1a" + (timeAfterReport - costTimeStart) + "ms");
        } else {
            ReportService.request(reportReqData);
            long timeAfterReport = System.currentTimeMillis();
            Util.log("pay+report\u603b\u8017\u65f6\uff08\u540c\u6b65\u65b9\u5f0f\u4e0a\u62a5\uff09\uff1a" + (timeAfterReport - costTimeStart) + "ms");
        }
        if (refundQueryResData == null || refundQueryResData.getReturn_code() == null) {
            this.setResult("Case1:\u9000\u6b3e\u67e5\u8be2API\u8bf7\u6c42\u903b\u8f91\u9519\u8bef\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u6d4b\u4f20\u8fc7\u53bb\u7684\u6bcf\u4e00\u4e2a\u53c2\u6570\u662f\u5426\u5408\u6cd5\uff0c\u6216\u662f\u770bAPI\u80fd\u5426\u88ab\u6b63\u5e38\u8bbf\u95ee", "logTypeError");
            resultListener.onFailByReturnCodeError(refundQueryResData);
            return;
        }
        if (refundQueryResData.getReturn_code().equals("FAIL")) {
            this.setResult("Case2:\u9000\u6b3e\u67e5\u8be2API\u7cfb\u7edf\u8fd4\u56de\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4bPost\u7ed9API\u7684\u6570\u636e\u662f\u5426\u89c4\u8303\u5408\u6cd5", "logTypeError");
            resultListener.onFailByReturnCodeFail(refundQueryResData);
        } else {
            log.i("\u9000\u6b3e\u67e5\u8be2API\u7cfb\u7edf\u6210\u529f\u8fd4\u56de\u6570\u636e");
            if (!Signature.checkIsSignValidFromResponseString(refundQueryServiceResponseString)) {
                this.setResult("Case3:\u9000\u6b3e\u67e5\u8be2API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u6709\u53ef\u80fd\u6570\u636e\u88ab\u7be1\u6539\u4e86", "logTypeError");
                resultListener.onFailBySignInvalid(refundQueryResData);
                return;
            }
            if (refundQueryResData.getResult_code().equals("FAIL")) {
                Util.log("\u51fa\u9519\uff0c\u9519\u8bef\u7801\uff1a" + refundQueryResData.getErr_code() + "     \u9519\u8bef\u4fe1\u606f\uff1a" + refundQueryResData.getErr_code_des());
                this.setResult("Case4:\u3010\u9000\u6b3e\u67e5\u8be2\u5931\u8d25\u3011", "logTypeError");
                resultListener.onRefundQueryFail(refundQueryResData);
            } else {
                this.getRefundOrderListResult(refundQueryServiceResponseString);
                this.setResult("Case5:\u3010\u9000\u6b3e\u67e5\u8be2\u6210\u529f\u3011", "logTypeInfo");
                resultListener.onRefundQuerySuccess(refundQueryResData);
            }
        }
    }

    private void getRefundOrderListResult(String refundQueryResponseString) throws ParserConfigurationException, SAXException, IOException {
        List<RefundOrderData> refundOrderList = XMLParser.getRefundOrderList(refundQueryResponseString);
        int count = 1;
        for (RefundOrderData refundOrderData : refundOrderList) {
            Util.log("\u9000\u6b3e\u8ba2\u5355\u6570\u636eNO" + count + ":");
            Util.log(refundOrderData.toMap());
            orderListResult = orderListResult + refundOrderData.toMap().toString();
            ++count;
        }
        log.i("\u67e5\u8be2\u5230\u7684\u7ed3\u679c\u5982\u4e0b\uff1a");
        log.i(orderListResult);
    }

    public void setRefundQueryService(RefundQueryService service) {
        this.refundQueryService = service;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        RefundQueryBusiness.result = result;
    }

    public void setResult(String result, String type) {
        this.setResult(result);
        log.log(type, result);
    }

    public static interface ResultListener {
        public void onFailByReturnCodeError(RefundQueryResData var1);

        public void onFailByReturnCodeFail(RefundQueryResData var1);

        public void onFailBySignInvalid(RefundQueryResData var1);

        public void onRefundQueryFail(RefundQueryResData var1);

        public void onRefundQuerySuccess(RefundQueryResData var1);
    }
}

