/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.business;

import com.tencent.common.Configure;
import com.tencent.common.Log;
import com.tencent.common.Signature;
import com.tencent.common.Util;
import com.tencent.common.report.ReporterFactory;
import com.tencent.common.report.protocol.ReportReqData;
import com.tencent.common.report.service.ReportService;
import com.tencent.protocol.refund_protocol.RefundReqData;
import com.tencent.protocol.refund_protocol.RefundResData;
import com.tencent.service.RefundService;
import org.slf4j.LoggerFactory;

public class RefundBusiness {
    private static Log log = new Log(LoggerFactory.getLogger(RefundBusiness.class));
    private static String result = "";
    private RefundService refundService = new RefundService();

    public void run(RefundReqData refundReqData, ResultListener resultListener) throws Exception {
        long costTimeStart = System.currentTimeMillis();
        log.i("\u9000\u6b3e\u67e5\u8be2API\u8fd4\u56de\u7684\u6570\u636e\u5982\u4e0b\uff1a");
        String refundServiceResponseString = this.refundService.request(refundReqData);
        long costTimeEnd = System.currentTimeMillis();
        long totalTimeCost = costTimeEnd - costTimeStart;
        log.i("api\u8bf7\u6c42\u603b\u8017\u65f6\uff1a" + totalTimeCost + "ms");
        log.i(refundServiceResponseString);
        RefundResData refundResData = (RefundResData)Util.getObjectFromXML(refundServiceResponseString, RefundResData.class);
        ReportReqData reportReqData = new ReportReqData(refundResData.getDevice_info(), Configure.REFUND_API, (int)totalTimeCost, refundResData.getReturn_code(), refundResData.getReturn_msg(), refundResData.getResult_code(), refundResData.getErr_code(), refundResData.getErr_code_des(), refundResData.getOut_trade_no(), Configure.getIP());
        if (Configure.isUseThreadToDoReport()) {
            ReporterFactory.getReporter(reportReqData).run();
            long timeAfterReport = System.currentTimeMillis();
            Util.log("pay+report\u603b\u8017\u65f6\uff08\u5f02\u6b65\u65b9\u5f0f\u4e0a\u62a5\uff09\uff1a" + (timeAfterReport - costTimeStart) + "ms");
        } else {
            ReportService.request(reportReqData);
            long timeAfterReport = System.currentTimeMillis();
            Util.log("pay+report\u603b\u8017\u65f6\uff08\u540c\u6b65\u65b9\u5f0f\u4e0a\u62a5\uff09\uff1a" + (timeAfterReport - costTimeStart) + "ms");
        }
        if (refundResData == null || refundResData.getReturn_code() == null) {
            this.setResult("Case1:\u9000\u6b3eAPI\u8bf7\u6c42\u903b\u8f91\u9519\u8bef\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u6d4b\u4f20\u8fc7\u53bb\u7684\u6bcf\u4e00\u4e2a\u53c2\u6570\u662f\u5426\u5408\u6cd5\uff0c\u6216\u662f\u770bAPI\u80fd\u5426\u88ab\u6b63\u5e38\u8bbf\u95ee", "logTypeError");
            resultListener.onFailByReturnCodeError(refundResData);
            return;
        }
        if (refundResData.getReturn_code().equals("FAIL")) {
            this.setResult("Case2:\u9000\u6b3eAPI\u7cfb\u7edf\u8fd4\u56de\u5931\u8d25\uff0c\u8bf7\u68c0\u6d4bPost\u7ed9API\u7684\u6570\u636e\u662f\u5426\u89c4\u8303\u5408\u6cd5", "logTypeError");
            resultListener.onFailByReturnCodeFail(refundResData);
        } else {
            log.i("\u9000\u6b3eAPI\u7cfb\u7edf\u6210\u529f\u8fd4\u56de\u6570\u636e");
            if (!Signature.checkIsSignValidFromResponseString(refundServiceResponseString)) {
                this.setResult("Case3:\u9000\u6b3e\u8bf7\u6c42API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u6709\u53ef\u80fd\u6570\u636e\u88ab\u7be1\u6539\u4e86", "logTypeError");
                resultListener.onFailBySignInvalid(refundResData);
                return;
            }
            if (refundResData.getResult_code().equals("FAIL")) {
                log.i("\u51fa\u9519\uff0c\u9519\u8bef\u7801\uff1a" + refundResData.getErr_code() + "     \u9519\u8bef\u4fe1\u606f\uff1a" + refundResData.getErr_code_des());
                this.setResult("Case4:\u3010\u9000\u6b3e\u5931\u8d25\u3011", "logTypeError");
                resultListener.onRefundFail(refundResData);
            } else {
                this.setResult("Case5:\u3010\u9000\u6b3e\u6210\u529f\u3011", "logTypeInfo");
                resultListener.onRefundSuccess(refundResData);
            }
        }
    }

    public void setRefundService(RefundService service) {
        this.refundService = service;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        RefundBusiness.result = result;
    }

    public void setResult(String result, String type) {
        this.setResult(result);
        log.log(type, result);
    }

    public static interface ResultListener {
        public void onFailByReturnCodeError(RefundResData var1);

        public void onFailByReturnCodeFail(RefundResData var1);

        public void onFailBySignInvalid(RefundResData var1);

        public void onRefundFail(RefundResData var1);

        public void onRefundSuccess(RefundResData var1);
    }
}

