/*
 * Decompiled with CFR 0.152.
 */
package com.tencent;

import com.tencent.business.DownloadBillBusiness;
import com.tencent.business.RefundBusiness;
import com.tencent.business.RefundQueryBusiness;
import com.tencent.business.ScanPayBusiness;
import com.tencent.common.Configure;
import com.tencent.protocol.downloadbill_protocol.DownloadBillReqData;
import com.tencent.protocol.pay_protocol.ScanPayReqData;
import com.tencent.protocol.pay_query_protocol.ScanPayQueryReqData;
import com.tencent.protocol.refund_protocol.RefundReqData;
import com.tencent.protocol.refund_query_protocol.RefundQueryReqData;
import com.tencent.protocol.reverse_protocol.ReverseReqData;
import com.tencent.service.DownloadBillService;
import com.tencent.service.RefundQueryService;
import com.tencent.service.RefundService;
import com.tencent.service.ReverseService;
import com.tencent.service.ScanPayQueryService;
import com.tencent.service.ScanPayService;

public class WXPay {
    public static void initSDKConfiguration(String key, String appID, String mchID, String sdbMchID, String certLocalPath, String certPassword) {
        Configure.setKey(key);
        Configure.setAppID(appID);
        Configure.setMchID(mchID);
        Configure.setSubMchID(sdbMchID);
        Configure.setCertLocalPath(certLocalPath);
        Configure.setCertPassword(certPassword);
    }

    public static String requestScanPayService(ScanPayReqData scanPayReqData) throws Exception {
        return new ScanPayService().request(scanPayReqData);
    }

    public static String requestScanPayQueryService(ScanPayQueryReqData scanPayQueryReqData) throws Exception {
        return new ScanPayQueryService().request(scanPayQueryReqData);
    }

    public static String requestRefundService(RefundReqData refundReqData) throws Exception {
        return new RefundService().request(refundReqData);
    }

    public static String requestRefundQueryService(RefundQueryReqData refundQueryReqData) throws Exception {
        return new RefundQueryService().request(refundQueryReqData);
    }

    public static String requestReverseService(ReverseReqData reverseReqData) throws Exception {
        return new ReverseService().request(reverseReqData);
    }

    public static String requestDownloadBillService(DownloadBillReqData downloadBillReqData) throws Exception {
        return new DownloadBillService().request(downloadBillReqData);
    }

    public static void doScanPayBusiness(ScanPayReqData scanPayReqData, ScanPayBusiness.ResultListener resultListener) throws Exception {
        new ScanPayBusiness().run(scanPayReqData, resultListener);
    }

    public static void doRefundBusiness(RefundReqData refundReqData, RefundBusiness.ResultListener resultListener) throws Exception {
        new RefundBusiness().run(refundReqData, resultListener);
    }

    public static void doRefundQueryBusiness(RefundQueryReqData refundQueryReqData, RefundQueryBusiness.ResultListener resultListener) throws Exception {
        new RefundQueryBusiness().run(refundQueryReqData, resultListener);
    }

    public static void doDownloadBillBusiness(DownloadBillReqData downloadBillReqData, DownloadBillBusiness.ResultListener resultListener) throws Exception {
        new DownloadBillBusiness().run(downloadBillReqData, resultListener);
    }
}

