package edu.ecompus.cas.web.init;


import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import edu.ecompus.core.job.ConvertJob;
import edu.ecompus.core.util.EnvProperUtil;
import edu.ecompus.core.util.KeyWordFilterUtil;

/**
 * 初始化Servlet
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author Author：        <JannyShao>
 * Create Date：  <2013-6-24 下午4:05:51>
 */
public class CasInitServlet extends HttpServlet {
	private static final long serialVersionUID = 7084114208116189070L;
	
	private static Logger logger = LoggerFactory.getLogger(CasInitServlet.class);
	
	/**
     * Initialization of the servlet. <br>
     * 
     * @throws ServletException
     *             if an error occure
     */
    public void init() throws ServletException {
    	if(logger.isInfoEnabled()) {
    		logger.info("开始读取配置文件....");
    	}
    	
    	ServletContext ctx = getServletContext();                      //获取上下文对象
    	
    	//读取网站所在硬盘的绝对路径
    	EnvProperUtil.webrealpath = ctx.getRealPath("/");
    	
    	try {
    		EnvProperUtil.initProps();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
    	//敏感词列表
    	logger.info("	启动敏感词列表初始化....");
    	try {
			KeyWordFilterUtil.initPatternByProps(EnvProperUtil.webrealpath);
		} catch (Exception e) {
		}
    	
    	//启动线程处理池
    	if(logger.isInfoEnabled()) {
    		logger.info("	启动线程处理池....");
    	}
    	ConvertJob.init();
		

    }
}
