package edu.ecompus.cas.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import lombok.Data;

import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddressList;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormat;

import edu.ecompus.cas.util.StringUtil;


/**
 * 导出Excel文件
 * 
 * 
 * @CopyRight CopyRright (c) 2013: <紫悦新橙> Project: <数字化校园 > Module ID:
 *            <(模块)类编号，可以引用系统设计中的类编号> Comments: <对此类的描述，可以引用系统设计中的描述> JDK
 *            version used: <JDK1.6>
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-7-3 上午9:43:43
 */
public @Data class ExportExcel {
	
	private HSSFWorkbook wb = null;
	//工作表
	private HSSFSheet sheet = null;

	private HSSFDataFormat format = null;
	//第一列
	private HSSFRow hdRow = null;

	int listlength = 0;

	/**
	 * 设置工作表的格式
	 * 
	 * @param sheetName
	 */
	public ExportExcel() {
		wb = new HSSFWorkbook();
	}

	public void createSheet(String sheetName) {
		sheet = wb.createSheet(sheetName);
		format = wb.createDataFormat();
		hdRow = sheet.createRow(0);
		//sheet.setDefaultRowHeightInPoints(120);
		//sheet.setDefaultColumnWidth(12);
	}


	/**
	 * 表头数据
	 * @param rowvalues	表头标题列表
	 * @param isFilter	是否带样式
	 * @throws Exception
	 */
	public void addHeader(List<String> rowvalues, boolean isFilter) throws Exception {
		listlength = rowvalues.size();
		// 设置字体
		HSSFFont workFont = wb.createFont();
		workFont.setFontName("微软雅黑");
		workFont.setFontHeightInPoints((short) 14);
		workFont.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		// 表头样式及背景色
		HSSFCellStyle hdStyle = wb.createCellStyle();
		hdStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		hdStyle.setBottomBorderColor(HSSFColor.BLACK.index);
		hdStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		hdStyle.setLeftBorderColor(HSSFColor.BLACK.index);
		hdStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
		hdStyle.setRightBorderColor(HSSFColor.BLACK.index);
		hdStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
		hdStyle.setTopBorderColor(HSSFColor.BLACK.index);
		hdStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
		hdStyle.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
		hdStyle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		hdStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		hdStyle.setFont(workFont);

		int i=0;
		for(String title : rowvalues){
			HSSFCell cell1 = hdRow.createCell(i++);
			HSSFRichTextString value = new HSSFRichTextString(title);
			cell1.setCellValue(value);
			if (isFilter == true) {
				cell1.setCellStyle(hdStyle);
			}
		}
		
	}

	/**
	 * 添加一行
	 */
	int s = 1;
	public void addRow(List rowvalues) {
		HSSFRow dtRow = sheet.createRow(s++);
		DataFormat format = wb.createDataFormat();

		HSSFCellStyle dtStyle = wb.createCellStyle();
		dtStyle.setDataFormat(format.getFormat("text"));
		dtStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		dtStyle.setBottomBorderColor(HSSFColor.BLACK.index);
		dtStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		dtStyle.setLeftBorderColor(HSSFColor.BLACK.index);
		dtStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
		dtStyle.setRightBorderColor(HSSFColor.BLACK.index);
		dtStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
		dtStyle.setTopBorderColor(HSSFColor.BLACK.index);
		dtStyle.setFillForegroundColor(HSSFColor.LIGHT_YELLOW.index);

		HSSFCellStyle dateStyle = wb.createCellStyle();
		dateStyle.setDataFormat(format.getFormat("yyyy-m-d"));
		dateStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		dateStyle.setBottomBorderColor(HSSFColor.BLACK.index);
		dateStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		dateStyle.setLeftBorderColor(HSSFColor.BLACK.index);
		dateStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
		dateStyle.setRightBorderColor(HSSFColor.BLACK.index);
		dateStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
		dateStyle.setTopBorderColor(HSSFColor.BLACK.index);
		dateStyle.setFillForegroundColor(HSSFColor.LIGHT_YELLOW.index);

		for (int j = 0; j < rowvalues.size(); j++) {
			String flag = "";
			Object cell_data = rowvalues.get(j);
			HSSFCell cell = dtRow.createCell(j);
			// 正文格式
			if (cell_data instanceof String) {
				flag = "string";
				cell.setCellValue((String) cell_data);
			} else if (cell_data instanceof Double) {
				cell.setCellValue((Double) cell_data);
			} else if (cell_data instanceof Integer) {
				cell.setCellValue(Double.valueOf(String.valueOf(cell_data)));
			} else if (cell_data instanceof Date) {
				flag = "date";
				cell.setCellValue((Date) cell_data);
			} else if (cell_data instanceof Boolean) {
				cell.setCellValue((Boolean) cell_data);
			} else if (cell_data instanceof Float) {
				cell.setCellValue((Float) cell_data);
			}
			// 背景颜色
			// if(s%2!=0)
			// dtStyle.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
			// dtStyle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
			if (flag == "" || flag.equals("string")) {
				cell.setCellStyle(dtStyle);
			} else if (flag.equals("date")) {
				cell.setCellStyle(dateStyle);
			}

		}
		// }
	}

	/**
	 * 给指定的行追加一行数据
	 * 
	 * @param rowvalues
	 * @param row
	 */
	public void insertRow(List rowvalues, int row) {
		sheet.shiftRows(row, sheet.getLastRowNum(), 1);
		HSSFRow dtRow = sheet.createRow(row);
		HSSFCellStyle dtStyle = wb.createCellStyle();
		dtStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		dtStyle.setBottomBorderColor(HSSFColor.BLACK.index);
		dtStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		dtStyle.setLeftBorderColor(HSSFColor.BLACK.index);
		dtStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);
		dtStyle.setRightBorderColor(HSSFColor.BLACK.index);
		dtStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);
		dtStyle.setTopBorderColor(HSSFColor.BLACK.index);
		dtStyle.setFillForegroundColor(HSSFColor.LIGHT_YELLOW.index);
		DataFormat format = wb.createDataFormat();
		Short str = format.getFormat("text");
		Short date = format.getFormat("yyyy-m-d");
		for (int j = 0; j < rowvalues.size(); j++) {
			Object cell_data = rowvalues.get(j);
			HSSFCell cell = dtRow.createCell(j);
			if (cell_data instanceof String) {
				dtStyle.setDataFormat(str);
				cell.setCellValue((String) cell_data);
			} else if (cell_data instanceof Double) {
				cell.setCellValue((Double) cell_data);
			} else if (cell_data instanceof Integer) {
				cell.setCellValue(Double.valueOf(String.valueOf(cell_data)));
			} else if (cell_data instanceof Date) {
				dtStyle.setDataFormat(date);
				cell.setCellValue((Date) cell_data);
			} else if (cell_data instanceof Boolean) {
				cell.setCellValue((Boolean) cell_data);
			} else if (cell_data instanceof Float) {
				cell.setCellValue((Float) cell_data);
			}
			// 背景颜色
			// if(s%2!=0)
			// dtStyle.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
			// dtStyle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
			cell.setCellStyle(dtStyle);
		}
	}

	/**
	 * 删除指定的行
	 * 
	 * @param row
	 */
	public void delRow(int row) {
		if (row > 0) {
			try {
				// HSSFRow dtRow = sheet.getRow(row);
				sheet.shiftRows(row, sheet.getLastRowNum(), -1);
				// sheet.removeRow(dtRow);
			} catch (RuntimeException e) {
				e.printStackTrace();
				System.out.println("error");
			}
		} else {
			System.out.println("错误的");
		}
	}

	/**
	 * 给指定的列给出下拉列表
	 * @param row				开始行
	 * @param cells				开始列
	 * @param cellvalue			内容
	 * @param promptTitle		提示标题
	 * @param promptContent		提示内容
	 */
	public void setSelect(int row, int cells, List cellvalue ) {
		String[] str = new String[cellvalue.size()];
		for (int i = 0; i < cellvalue.size(); i++) {
			str[i] = (String) cellvalue.get(i);
		}
		
		setHSSFValidation(sheet, str, row, 65535, cells, cells); 
//		setHSSFPrompt(sheet, promptTitle, promptContent,row, 65535, cells, cells);
//        setHSSFPrompt(sheet, promptTitle, promptContent,row, 0, cells, cells);// 第二列的前501行都设置提示.   

		//sheetlist = setHSSFValidation(sheetlist, textlist, 0, 500, 0, 0);// 第一列的前501行都设置为选择列表形式.   
        //sheetlist = setHSSFPrompt(sheetlist, "promt Title", "prompt Content",0, 500, 1, 1);// 第二列的前501行都设置提示.   
//		CellRangeAddressList regions = new CellRangeAddressList(row, 65535,	cells, cells);
//		// 生成下拉框内容
//		DVConstraint constraint = DVConstraint.createExplicitListConstraint(str);
//		//绑定下拉框和作用区域
//		HSSFDataValidation dataValidate = new HSSFDataValidation(regions,	constraint);
//		//对sheet页生效// 加入数据有效性到当前sheet对象
//		sheet.addValidationData(dataValidate); 
	}
	
	/**
     * 设置某些列的值只能输入预制的数据,显示下拉框.
     * @param sheet 要设置的sheet.
     * @param textlist 下拉框显示的内容
     * @param firstRow 开始行
     * @param endRow 结束行
     * @param firstCol   开始列
     * @param endCol  结束列
     * @return 设置好的sheet.
     */  
    private void setHSSFValidation(HSSFSheet sheet,  
            String[] textlist, int firstRow, int endRow, int firstCol,  
            int endCol) {  
        // 加载下拉列表内容   
        DVConstraint constraint = DVConstraint.createExplicitListConstraint(textlist);  
        // 设置数据有效性加载在哪个单元格上,四个参数分别是：起始行、终止行、起始列、终止列   
        CellRangeAddressList regions = new CellRangeAddressList(firstRow,endRow, firstCol, endCol);  
        // 数据有效性对象   
        HSSFDataValidation data_validation_list = new HSSFDataValidation(regions, constraint);  
        sheet.addValidationData(data_validation_list);  
    }  
  
    /**
     * 设置单元格上提示
     * @param sheet  要设置的sheet.
     * @param promptTitle 标题
     * @param promptContent 内容
     * @param firstRow 开始行
     * @param endRow  结束行
     * @param firstCol  开始列
     * @param endCol  结束列
     * @return 设置好的sheet.
     */  
    private void setHSSFPrompt(HSSFSheet sheet, String promptTitle,  
            String promptContent, int firstRow, int endRow ,int firstCol,int endCol) {  
        // 构造constraint对象   
        DVConstraint constraint = DVConstraint.createCustomFormulaConstraint("BB1");  
        // 四个参数分别是：起始行、终止行、起始列、终止列   
        CellRangeAddressList regions = new CellRangeAddressList(firstRow,endRow,firstCol, endCol);  
        // 数据有效性对象   
        HSSFDataValidation data_validation_view = new HSSFDataValidation(regions,constraint);  
        data_validation_view.createPromptBox(promptTitle, promptContent);  
        sheet.addValidationData(data_validation_view);  
    }  

	/**
	 * 具体文件生成的路径
	 * 
	 * @param file
	 * @throws Exception
	 */
	public void exportExcel(String file) throws Exception {
		FileOutputStream fileOut = new FileOutputStream(file);
		wb.write(fileOut);
		fileOut.close();
	}

	/**
	 * 具体文件生成的文件
	 * 
	 * @param file
	 * @throws Exception
	 */
	public void exportExcel(File file) throws Exception {
		FileOutputStream fileOut = new FileOutputStream(file);
		wb.write(fileOut);
		fileOut.close();
	}

	/**
	 * 具体文件生成的文件
	 * 
	 * @param file
	 * @throws Exception
	 */
	public void exportExcel(OutputStream outputstream) throws Exception {
		BufferedOutputStream buffout = new BufferedOutputStream(outputstream);
		wb.write(buffout);
		buffout.flush();
		buffout.close();
	}

	/**
	 * 读取单元格内容
	 * @param cell
	 * @return
	 */
	public static Object getCellValue(HSSFCell cell){
		if(cell==null) return null;
		//单元格 格式设置为字符串型
		cell.setCellType(Cell.CELL_TYPE_STRING);
		return cell.getStringCellValue(); 
//		switch (cell.getCellType()) {   //根据cell中的类型来输出数据  
//	        //case HSSFCell.CELL_TYPE_NUMERIC:  
//	        //	return cell.getNumericCellValue();
//	        case HSSFCell.CELL_TYPE_STRING:  
//	        	return cell.getStringCellValue();  
//	        case HSSFCell.CELL_TYPE_BOOLEAN:  
//	            return cell.getBooleanCellValue();  
//	        case HSSFCell.CELL_TYPE_FORMULA:  
//	            return cell.getCellFormula();  
//	        default: 
//	        	return cell.getStringCellValue();  
//       }
	}
	
	
	
	public static void main(String[] args) throws Exception {
		String roleids = "1,2";
		Long roleId = 3l;
		
		System.out.println("contains="+roleids.contains(String.valueOf(roleId)));
		
//		//Excel 头行标题
//		List<String> headList = EntityConstant.getStudentExcelCell();
//		//男、女
//		List<String> sexList = EntityConstant.getUserSexCell();
//		//班级
//		List<String> classnamelist = new ArrayList<String>();
//		for(int i=0; i<10; i++){
//			classnamelist.add(String.format("大%s班", i));
//		}
//		ExportExcel s = new ExportExcel();  
//        s.createSheet("学生表");  
//        s.addHeader(headList, false);  
//        //性别
//        s.setSelect(1, 4, sexList);
//		//班级
//        s.setSelect(1, 5, classnamelist);
//		
//        
//        File file = new File("E:\\ss2.xls");
//        s.exportExcel(file);
        
//		List<String> list = new ArrayList<String>();
//		list.add("员工号");
//		list.add("姓名");
//		list.add("出生日前");
//		list.add("工作地点");
//		list.add("职务");
//		list.add("性别");
//		list.add("那裡");
//
//		ExportExcel s = new ExportExcel();
//		s.createSheet("系统报名表");
//		s.addHeader(list, true);
//		s.addHeader(list, false);
//
//		List lists = null;
//		for (int i = 0; i < 6; i++) {
//
//			lists = new ArrayList();
//			lists.add("A000" + i);
//			if (i == 1) {
//				lists.add("赵云");
//			} else if (i == 2) {
//				lists.add("关羽");
//			} else if (i == 3) {
//				lists.add("张飞");
//			} else if (i == 4) {
//				lists.add("什么");
//			} else if (i == 5) {
//				lists.add("那个");
//			}
//			lists.add("6500444444444444444444444444444444 ");
//			// new SimpleDateFormat("yyyy-M-d").format(new Date())
//			lists.add(new Date());
//			lists.add("生死战" + i);
//			lists.add("男" + i);
//			lists.add("常山的" + i);
//			s.addRow(lists);
//		}
//		List lists1 = new ArrayList();
//		lists1.add("五虎上将之一");
//		lists1.add("赵云");
//		lists1.add("6500");
//		lists1.add("2010-9-1");
//		lists1.add("生死战");
//		lists1.add("男sdfdsf");
//		lists1.add("weher");
//
//		s.insertRow(lists1, 3);
//		// s.insertRow(5, 6);
//		// s.delRow(5);
//		s.setSelect(3, 3, list);
//		s.createSheet("第二张系统报名表");// 第二张工作表
//
//		File file = new File("E:\\ss.xls");
//		s.exportExcel(file);
	}
}
