package edu.ecompus.cas.service.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.cas.Constant;
import edu.ecompus.cas.dao.ActionDAO;
import edu.ecompus.cas.dao.AppDAO;
import edu.ecompus.cas.dao.CompanyDAO;
import edu.ecompus.cas.dao.ModuleDAO;
import edu.ecompus.cas.dao.RoleDAO;
import edu.ecompus.cas.dao.RolePermitDAO;
import edu.ecompus.cas.dao.UserDAO;
import edu.ecompus.cas.dao.UserLoginLogDAO;
import edu.ecompus.cas.dao.UserPermitDAO;
import edu.ecompus.cas.dao.UserRoleDAO;
import edu.ecompus.cas.entity.Action;
import edu.ecompus.cas.entity.App;
import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.Module;
import edu.ecompus.cas.entity.Role;
import edu.ecompus.cas.entity.RolePermit;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserLoginLog;
import edu.ecompus.cas.entity.UserPermit;
import edu.ecompus.cas.entity.UserRole;
import edu.ecompus.cas.service.UserPermitService;
import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;


/**
 * 
 * 用户权限角色服务层接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-27 上午10:43:39
 */
@Service("userPermitService")
public class UserPermitServiceImpl extends GenerateService implements
		UserPermitService {
	/**
	 * 用户-DAO
	 */
	@Autowired
	private UserDAO userDao;
	
	
	/**
	 * 动作-DAO
	 */
	@Autowired
	private ActionDAO actionDao;
	
	/**
	 * 应用-DAO
	 */
	@Autowired
	private AppDAO appDao;
	
	/**
	 * 角色-DAO
	 */
	@Autowired
	private RoleDAO roleDao;
	
	/**
	 * 用户角色-DAO
	 */
	@Autowired
	private UserRoleDAO userRoleDao;
	
	/**
	 * 模块-DAO
	 */
	@Autowired
	private ModuleDAO moduleDao;
	
	
	
	/**
	 * 用户权限-DAO
	 */
	@Autowired
	private UserPermitDAO userPermitDao;
	
	/**
	 * 角色权限-DAO
	 */
	@Autowired
	private RolePermitDAO rolePermitDao;

	
	/**
	 * 单位-DAO
	 */
	@Autowired
	CompanyDAO companyDao;
	
	
	/**
	 * 单位-DAO
	 */
	@Autowired
	UserLoginLogDAO userLoginLogDAO;
	
	//=========================通用接口=====================================
	@Override
	public Object query2(Class clazz, Serializable id) {
		if (clazz == User.class)
			return userDao.query(id);
		if (clazz == Action.class)
			return actionDao.query(id);
		if (clazz == App.class)
			return appDao.query(id);
		if (clazz == Module.class)
			return moduleDao.query(id);
		if (clazz == Role.class)
			return roleDao.query(id);
		if (clazz == RolePermit.class)
			return rolePermitDao.query(id);
		if (clazz == UserPermit.class)
			return userPermitDao.query(id);
		if (clazz == UserRole.class)
			return userRoleDao.query(id);
		if (clazz == Company.class)
			return companyDao.query(id);
		
		return null;
	}
	
	
	@Override
	public Object add2(Class clazz, Object obj) {
		if (clazz == User.class)
			userDao.create((User) obj);
		else if (clazz == Action.class)
			actionDao.create((Action) obj);
		else if (clazz == App.class)
			appDao.create((App) obj);
		else if (clazz == Module.class)
			moduleDao.create((Module) obj);
		else if (clazz == Role.class)
			roleDao.create((Role) obj);
		else if (clazz == RolePermit.class)
			rolePermitDao.create((RolePermit) obj);
		else if (clazz == UserPermit.class)
			userPermitDao.create((UserPermit) obj);
		else if (clazz == UserRole.class)
			userRoleDao.create((UserRole) obj);
		else if (clazz == Company.class)
			companyDao.create((Company) obj);
		else if (clazz == UserLoginLog.class)
			userLoginLogDAO.create((UserLoginLog) obj);
//		else 
//			throw new ML2DaoException(Constant.UNSUPPORTEDCLASS_CODE,Constant.UNSUPPORTEDCLASS_MESSAGE + ":" + clazz.getName());
		
		return obj;
	}


	@Override
	public Object delete2(Class clazz, Object obj) {
		if (clazz == User.class)
			userDao.delete((User) obj);
		else if (clazz == Action.class)
			actionDao.delete((Action) obj);
		else if (clazz == App.class)
			appDao.delete((App) obj);
		else if (clazz == Module.class)
			moduleDao.delete((Module) obj);
		else if (clazz == Role.class)
			roleDao.delete((Role) obj);
		else if (clazz == RolePermit.class)
			rolePermitDao.delete((RolePermit) obj);
		else if (clazz == UserPermit.class)
			userPermitDao.delete((UserPermit) obj);
		else if (clazz == UserRole.class)
			userRoleDao.delete((UserRole) obj);
		else if (clazz == Company.class)
			companyDao.delete((Company) obj);
//		else 
//			throw new ML2DaoException(Constant.UNSUPPORTEDCLASS_CODE,Constant.UNSUPPORTEDCLASS_MESSAGE + ":" + clazz.getName());
		
		return obj;
	}


	@Override
	public Object modify2(Class clazz, Object obj) {
		if (clazz == User.class)
			userDao.update((User) obj);
		else if (clazz == Action.class)
			actionDao.update((Action) obj);
		else if (clazz == App.class)
			appDao.update((App) obj);
		else if (clazz == Module.class)
			moduleDao.update((Module) obj);
		else if (clazz == Role.class)
			roleDao.update((Role) obj);
		else if (clazz == RolePermit.class)
			rolePermitDao.update((RolePermit) obj);
		else if (clazz == UserPermit.class)
			userPermitDao.update((UserPermit) obj);
		else if (clazz == UserRole.class)
			userRoleDao.update((UserRole) obj);
		else if (clazz == Company.class)
			companyDao.update((Company) obj);
//		else 
//			throw new ML2DaoException(Constant.UNSUPPORTEDCLASS_CODE,Constant.UNSUPPORTEDCLASS_MESSAGE + ":" + clazz.getName());
		
		return obj;
	}
	
	
	
	//=========================用户相关接口=====================================
	@Override
	public User queryUserByUserName(String userName){
		if("".equals(userName)){
			return null;
		}
		return this.userDao.getUser(userName);
	}
	
	@Override
	public List<User> getUserByIds(String ids) {
		if(ids==null || "".equals(ids))
		{
			return Collections.emptyList();
		}
		
		return this.userDao.queryUserByIds(ids);
	}

	//=========================动作相关接口=====================================
	@Override
	public void createAction(Action action) {
		this.actionDao.create(action);
		
	}

	@Override
	public void cancelAction(Action action) {
		action.setState(2);
		this.actionDao.update(action);
		
	}

	@Override
	public List<Action> queryActionList(Page page) {
		return this.actionDao.getActionList(page);
	}
	
	//=========================模块相关接口=====================================
	@Override
	public void createModule(Module module) {
		this.moduleDao.create(module);
		
	}

	@Override
	public void cancelModule(Module module) {
		module.setState(2);
		this.moduleDao.update(module);
		
	}

	//=========================应用相关接口=====================================
	@Override
	public void createApp(App app) {
		this.appDao.create(app);
		
	}

	@Override
	public void cancelApp(App app) {
		app.setState(2);
		this.appDao.update(app);
		
	}
	
	@Override
	public App getAppByclientId(String clientId) {
		if(clientId!=null && !"".equals(clientId)){
			return appDao.queryClientByClientId(clientId);
		}
		
		return null;
	}
	//=========================角色相关接口=====================================
	@Override
	public void createRole(Role role) {
		this.roleDao.create(role);
	}

	//=========================用户角色相关接口=====================================
	@Override
	public void createUserRole(UserRole userRole) {
		this.userRoleDao.create(userRole);
	}

	@Override
	public List<UserRole> queryUserRoleList(User user) {
		if(user==null){
			return Collections.emptyList();
		}
		
		return this.userRoleDao.queryUserRoleList(user.getId());
	}

	@Override
	public void deleteUserRole(UserRole userRole) {
		this.userRoleDao.delete(userRole);
	}

	@Override
	public void clearUserRole(User user) {
		this.userRoleDao.clearUserRole(user.getId());
	}

	
	//=========================用户权限相关接口=====================================
	@Override
	public void createUserPermit(UserPermit userpermit) {
		//TODO || (userpermit.getApp()!=null && userpermit.getModuleAction()!=null) 
		//判断app或者MA两者其中一项不允许为NULL
		if(userpermit==null || userpermit.getUser()==null ){
			return;
		}
		
		this.userPermitDao.create(userpermit);
	}

	@Override
	public void clearUserPermit(User user) {
		this.userPermitDao.clearUserPermit(user);
	}

	@Override
	public void deleteUserPermit(UserPermit userPermit) {
		this.userPermitDao.delete(userPermit);
	}

	@Override
	public List<UserPermit> queryUserPermitList(User user){
		if(user==null){
			return Collections.emptyList();
		}
		
		return this.userPermitDao.getUserPermitList(user);
	}

	
	//=========================角色权限相关接口=====================================
	@Override
	public void createRolePermit(RolePermit rolePermit) {
		//TODO || (userpermit.getApp()!=null && userpermit.getModuleAction()!=null) 
		//判断app或者MA两者其中一项不允许为NULL
		
		this.rolePermitDao.create(rolePermit);
		
	}

	//@   CacheEvict(value = "demo1", key = "#entity.userId")
	@Override
	public void clearRolePermit(Role role) {
		
		this.rolePermitDao.clearRolePermit(role);
	}

	@Override
	public void deleteRolePermit(RolePermit rolePermit) {
		
		this.rolePermitDao.delete(rolePermit);
	}

	@Override
	public List<RolePermit> queryRolePermitList(Role role){
		if(role==null){
			return Collections.emptyList();
		}
		
		return this.rolePermitDao.getRolePermitList(role);
	}


	@Override
	@Cacheable(value="rolePermitListCache",key="#roleIds")
	public List<RolePermit> queryRolePermitList(String roleIds){
		if(roleIds.equals("")){
			return Collections.emptyList();
		}
		
		return this.rolePermitDao.getRolePermitList(roleIds);
	}


	@Override
	public Long countLogin(Long userId) {
		return this.userLoginLogDAO.countLogin(userId);
	}




	
	
	
}
