package edu.ecompus.cas.service;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.cas.entity.UserVerify;

/**
 * <b>用户</b> 服务层接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author wsh
 * @since Date： 2013-8-6 下午3:06:57
 */
@Transactional
public interface UserVerifyService {

	/**
	 * 创建用户验证
	 * @param userVerify
	 */
	void createUserVerify(UserVerify userVerify);
	
	/**
	 * 根据用户ID查询用户验证表
	 * @param userId
	 */
	UserVerify getUserVerifyByUserId(Long userId);
	
	/**
	 * 根据用户ID更新用户验证表
	 * @param userVerify
	 */
	int updateUserVerifyByUserId(UserVerify userVerify);
	
	/**
	 * 删除令牌
	 * @param token
	 */
	void deleteUserVerifyByToken(String token);
}

