package edu.ecompus.cas.entity;


import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;


/**
 * 
 * 用户角色表
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-27 上午9:31:45
 */
@Entity
@Table(name = "TAB_USER_ROLE")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class UserRole implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8186801086551617555L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/** 用户 **/
	private Long user_id;
	
	/** 角色 **/
	private Long role_id;
	
}
