package edu.ecompus.cas.entity;


import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 用户绑定表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-11-25 下午5:15:31
 */
@Entity
@Table(name = "TAB_USER_BIND")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class UserBind implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 9193097341364295212L;

	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 用户编号
	 * @see User.id
	 * **/
	private Long userId;
	
	/**
	 * 关系,例如:爸爸,奶奶,妈妈,爷爷...
	 */
	private String relation;
	
	/**
	 * 关系编号
	 * @see User.id
	 */
	private Long relationId;
	/**
	 * 关系登录名
	 */
	private String relationUserName;
	/**
	 * 关系密码(MD5)
	 */
	private String relationPassword;
	
	/**
	 * 所属学校
	 * @see Company
	 */
	private Long schoolId;
	
	/**
	 * 微信号
	 */
	private String winxinID;
	
	/**QQID**/
	private String qqId;
	
	/**新浪ID**/
	private String sinaId;

	
	
	//==TODO 其他三方绑定

	
	
}
