package edu.ecompus.cas.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
/**
 * 用户应用表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-3 下午4:53:57
 */
@Entity
@Table(name = "TAB_USER_APP")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class UserApp implements Serializable {
	private static final long serialVersionUID = 7015122938672195778L;

	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/** 用户 **/
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="user_id")
	private User user;
	
	/**
	 * 所属学校
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="school_id")
	private Company school;	
	
	/**
	 * 应用状态:1-显示,2-隐藏
	 */
	private int state = 1;
	
	/**
	 * 创建日期
	 */
	private Date	createDate;
	
	/**
	 * 学校APP
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="schoolapp_id")
	private CompanyApp schoolApp;
	
	
	
	
}
