package edu.ecompus.cas.entity;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * oauth2.0  访问令牌表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-11 下午4:32:28
 */
@Entity
@Table(name = "TAB_OAUTH2_ACCESS_TOKEN")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class Oauth2AccessToken implements Serializable {
	private static final long serialVersionUID = 1259350550863778261L;
	
	/** 请求ID **/
	@Id
	private String tokenId;
	
	/**  **/
    private byte[] token;
    /**  **/
    private String authenticationId;
    /**  **/
    private byte[] authentication;
    /**  **/
    private String refreshToken;
    /** 用户名 **/
    private String userName;
    /** App应用 **/
    private String clientId;
    
    
    
    
    
}
