package edu.ecompus.cas.entity;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 机构注册申请表
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-7-28 上午9:00:10
 */
@Entity
@Table(name="TAB_COMPANY_REG")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class CompanyReg implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -7291279153612376378L;

	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 单位编号
	 * @see Company.id
	 */
	private Long schoolId;
	
	/** 单位/学校  名称  **/
	private String name; //单位名称
	
	/** 单位联系人  **/
	private String contact; //单位联系人
	
	/** 联系电话  **/
	private String telphone; //联系电话
	
	private String mobile; //联系手机
	
	/** 邮箱  **/
	private String email; //邮箱
	
	/** 省  **/
	private String province; //省
	/** 市  **/
	private String city; //市
	/** 区、县  **/
	private String area; //区、县
	/** 联系地址  **/
	private String address; //联系地址
	
	/**
	 * 机构类型	(1000-幼儿园 1001-小学 1002-初中 1003-高中 1004-职教 1005-大学)
	 */
	private int classify = 1000;
	
	/** 
	 * 单位类型
	 * <li>2000-公办园所,2001-民办园所,2002-合作园所,2003-早教机构
	 *   **/
	private int type = 2000;          //单位类型
	
	/**
	 * 园所等级 
	 * 0-示范园
	 * 1-一级园
	 * 2-二级园
	 * 3-三级园
	 */
	private int leavel = 0;
	
	/**
	 * 办园许可证
	 */
	private String licenseUrl;
	
	 /**
     * 登陆用户名(登陆号)       db_column: username 
     */ 	
	private String username;
	
    /**
     * 用户密码       db_column: password 
     */ 	
	private String password;
	
	/** 状态 0-新申请 1-审核通过 2-不通过 **/
	private int status = 0;
	
	/** 申请日期  **/
	private Date createDate; 
	
	/**审核令牌**/
	//private String veriftoken;

	/**审核令牌值**/
	//private String verifvalue;
	
	/**
	 * 验证人编号
	 * @see User.id
	 */
	private Long verifUserId;
	
	/** 验证日期  **/
	private Date verifDate; 

	/**
	 * 备注
	 */
	private String remark;
	
	//==========@Transient===========================
	/**
	 * 用户角色列表
	 */
	@Transient
	private User verifuser;
	
	@Transient
	public String getCompanyClassify(){
		if(classify>0){
			if(classify==1000){
				return "幼儿园";
			}else if(classify==1001){
				return "小学";
			}else if(classify==1002){
				return "初中";
			}else if(classify==1003){
				return "高中";
			}else if(classify==1004){
				return "高职";
			}else if(classify==1005){
				return "大学";
			}else if(classify==1006){
				return "早教机构";
			}else if(classify==1007){
				return "#";
			}else if(classify==1008){
				return "#";
			}else if(classify==1009){
				return "教育局";
			}else if(classify==1010){
				return "#";
			}else{
				return "#";
			}
		}
		
		return "";
	}
	
	@Transient
	public String getCompanyType(){
		//2000-公办园所,2001-民办园所,2002-合作园所,2003-早教机构
		if(type>0){
			if(type==2000){
				return "公办";
			}else if(type==2001){
				return "民办";
			}else if(type==2002){
				return "合作";
			}else if(type==2003){
				return "早教机构";
			}else{
				return "#";
			}
		}
		
		return "";
	}
	
}
