package edu.ecompus.cas.entity;


import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;


/**
 * 
 * <b>应用表</b>
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-12 下午3:19:53
 */
@Entity
@Table(name = "TAB_APP")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class App implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = -7867471915648445652L;

	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 客户端编号
	 */
	@Column(name = "client_id")
	private String clientId;
	
	/**
     * 应用名称       db_column: name  例如:财务管理系统,etc... 
     */ 	
	private String name;
	
	/**
	 * 应用地址	 db_column: url		例如:http://appX.xxx.com/ OR  http://appX.xxx.com/appId/
	 * web_server_redirect_uri
	 * <ext>http://yourdomain/youapp
	 */
	private String url;
	
	/**
	 * 状态  例如:1-正常    2-注销
	 */
	private int state = 1;
	
	/**
	 * 是否可见1-true,0-false
	 */
	private int available = 1;
	
	/**
	 * 类型1-官方应用,2-三方应用
	 */
	private int type = 1;
	
	/**
	 * APP LOGO图标
	 */
	private String applogo;
	/**
	 * ICO地址
	 */
	private String icourl;
	
	/**
	 * APP简述
	 */
	private String appinfo;
	
	/**
	 * 开发者
	 */
	private String appauthor;
	
	/**
	 * 是否已发布0-测试,1-发布
	 */
	private int installs = 0; 
	
	
	//===================2013/9/3
	/**
	 * 应用别名
	 */
	private String alias;
	/**
	 * 用户api_key/client_secret
	 */
	private String apikey;
	
	/**
	 * API密钥
	 */
	private String securekey;
	
	/**
	 * app类型,1-微博应用,2-微信应用,3...
	 */
	private int apptype = 1;
	
	/**
	 * 资源Ids
	 */
	@Column(name = "resource_ids")
	private String resourceIds;
	
	/**
	 * 应用范围 read,write,trust
	 */
	@Column(name = "scope")
    private String scope;
    
	/**
	 * password,authorization_code,refresh_token,implicit
	 */
    @Column(name = "authorized_grant_types")
    private String authorizedGrantTypes;
    
    /**
	 * 重定向Web服务Url地址
	 */
    @Column(name = "web_server_redirect_uri")
    private String registeredRedirectUri;
    
    /**
     * ROLE_CLIENT, ROLE_TRUSTED_CLIENT
     */
    @Column(name = "authorities")
    private String persistentAuthorities;
    
    /**
     * 访问令牌 有效时长
     */
    @Column(name = "access_token_validity")
    private int accessTokenValiditySeconds = 60 * 60 * 12;
	
    /**
     * 刷新令牌 有效时长
     */
    @Column(name = "refresh_token_validity")
    private int refreshTokenValidity = 60 * 10;
	
    /**
     * 信息
     */
    @Column(name = "additional_information")
    private String additionalInformation;
	
//	/**
//	 * ROLE_CLIENT, ROLE_TRUSTED_CLIENT
//	 */
//	@Transient
//    private Collection<GrantedAuthority> transientGrantedAuthorities;
//	
//	

	
    
    
    
	
}
