package edu.ecompus.cas.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import edu.ecompus.cas.dao.UserRoleDAO;
import edu.ecompus.cas.entity.UserRole;
import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;

/**
 * 
 * 用户角色 数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-27 上午10:37:16
 */
@Repository
public @Slf4j class UserRoleDaoImpl extends ML2TemplateGenericDao<UserRole> implements
		UserRoleDAO {
	
	public UserRoleDaoImpl(){
		super(UserRole.class);
	}
	
	

	@SuppressWarnings("unchecked")
	@Override
	public List<UserRole> queryUserRoleList(Long userId) {
		return this.hibernateTemplate.find("from UserRole ur where ur.user_id=? order by role_id asc", new Object[]{userId});
	}



	@Override
	public void clearUserRole(Long userId) {
		StringBuffer sql = new StringBuffer("DELETE FROM UserRole ur where user_id=? and id>0");
		this.executeUpdate(sql.toString(), new Object[]{userId});
	}



	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Override
	public List<String> queryUserRoleResumeList(Long userId) {
		final StringBuffer sql = new StringBuffer(
				"SELECT name FROM ecompus2.TAB_ROLE where id in (SELECT role_id FROM ecompus2.TAB_USER_ROLE where user_id=").append(userId).append(")");
		return (List<String>) this.jdbcTemplate.query(sql.toString(),
				new ResultSetExtractor() {
					public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
						java.util.List<String> list = new java.util.ArrayList<String>();
						while (rs.next()) {
							list.add(rs.getString("name"));
						}
						
						return list;
					}
			});
	}



	@SuppressWarnings("unchecked")
	@Override
	public List<UserRole> queryUserRoleList(String roleNames, Long userId) {
		String[] rolename =  roleNames.split(",");
		String names = "";
		if(rolename.length>0){
			StringBuffer list = new StringBuffer("'").append(rolename[0]).append("'");
			if(rolename.length>1){
				for(String n : rolename){
					list.append(",'").append(n).append("'");
				}
			}
			
			names = list.toString();
		}else{
			names = roleNames;
		}
		StringBuffer sql = new StringBuffer("from UserRole ur where ur.user_id=").append(userId);
		sql.append(" and ur.role.name in (").append(names).append(")");
		sql.append(" order by role_id asc");
		
		log.info(sql.toString());
		return this.hibernateTemplate.find(sql.toString());
	}



	@SuppressWarnings("unchecked")
	@Override
	public List<UserRole> queryUserRoleList(Long roleId, Long userId) {
		return this.hibernateTemplate.find("from UserRole ur where ur.user_id=? and role_id=?", new Object[]{userId,roleId});
	}

}
