package edu.ecompus.cas.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.cas.dao.UserPermitDAO;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserPermit;
import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;

/**
 * 
 * 用户权限 数据持久类 操作接口实现
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-27 上午10:32:56
 */
@Repository
public class UserPermitDaoImpl extends ML2TemplateGenericDao<UserPermit> implements
		UserPermitDAO {

	public UserPermitDaoImpl(){
		super(UserPermit.class);
	}
	
	

	@SuppressWarnings("unchecked")
	@Override
	public List<UserPermit> getUserPermitList(User user) {
		return this.hibernateTemplate.find("from UserPermit up where up.user=?", new Object[]{user});
	}



	@Override
	public void clearUserPermit(User user) {
		StringBuffer sql = new StringBuffer("delete from UserPermit up where up.user=?");
		this.executeUpdate(sql.toString(), new Object[]{user});
	}

}
