package edu.ecompus.cas.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.cas.dao.UserAppDAO;
import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.CompanyApp;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserApp;
import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;

/**
 * <b>用户应用 </b>  数据持久类 操作接口实现
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-3 下午5:10:31
 */
@Repository
public class UserAppDaoImpl extends ML2TemplateGenericDao<UserApp> implements
		UserAppDAO {


	public UserAppDaoImpl() {
		super(UserApp.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<UserApp> queryUserApp(User user, Company school, int state) {
		StringBuffer sql = new StringBuffer("from UserApp where user=? and school=? and schoolApp.state=1");
		
		if(state!=-1){
			sql.append(" and state=").append(state);
		}
		
		return this.hibernateTemplate.find(sql.toString(), new Object[]{user,school});
	}

	@Override
	public Long countActivateApp(User user, CompanyApp cpp, Company school) {
		StringBuffer sql = new StringBuffer("SELECT count(id) from UserApp where school=?");
		
		if(user!=null){
			sql.append(" and user_id=").append(user.getId());
		}
		
		if(cpp!=null){
			sql.append(" and schoolapp_id=").append(cpp.getId());
		}
		
		
		return (Long) this.queryForObject(sql.toString(), null);
		
	}

}
