package edu.ecompus.cas.dao;

import edu.ecompus.cas.entity.UserVerify;
import edu.ecompus.core.dao.ML2GenericDao;


/**
 * <b>用户验证 </b>  数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-3 下午5:05:42
 */
public interface UserVerifyDAO extends ML2GenericDao<UserVerify> {

	/**
	 * 创建用户验证
	 * @param userVerify
	 */
	void createUserVerify(UserVerify userVerify);
	
	/**
	 * 根据用户ID查询用户验证表
	 * @param userId
	 */
	UserVerify queryUserVerifyByUserId(Long userId);
	
	/**
	 * 更新用户验证表
	 * @param userVerify
	 */
	int updateUserVerifyByUserId(UserVerify userVerify);
	
	/**
	 * 删除令牌
	 * @param token
	 */
	void deleteUserVerifyByToken(String token);
}
