package edu.ecompus.cas.dao;

import java.util.List;

import edu.ecompus.cas.entity.User;
import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;

/**
 * 用户数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-26 下午2:58:10
 */
public interface UserDAO extends ML2GenericDao<User> {
	
	/**
	 * 根据用户名查询UserBase实体类
	 * 
	 * @param username
	 * @return
	 */
	public User getUser(String username);
	
	/**
	 * 根据用户昵称查询UserBase实体类
	 * @param name
	 * @return
	 */
	public User getUserByName(String name);
	
	/**
	 * 根据用户昵称查询UserBase实体类
	 * @param name
	 * @return
	 */
	public User getUserByNickName(String nickname);
	
	
	/**
	 * 根据手机号码查询UserBase实体类
	 * @param name
	 * @return
	 */
	public User getUserByMobile(String mob);
	
	
	/**
	 * 根据用户名与密码查询UserBase实体类
	 * @param username	用户名
	 * @param password	密码(md5加密)
	 * @return
	 */
	public User getUser(String username,String password);
	
	
	/**
	 * @param keyword		(NULL不为条件,模糊查询真实姓名与妮称)
	 * @param company		(NULL不为条件,所属学校)
	 * @param enabled		(-1不为条件,状态1-正常,2-禁用)
	 * @param mobile		(NULL不为条件,手机号码)
	 * @param identity		(NULL不为条件,模糊查询证件号码)
	 * @param page          (NULL不为条件,分页)
	 * @return
	 */
	List<User> queryUserList(String keyword,Long schoolId, int enabled, String mobile, String identity, Page page);
	
	/**
	 * 综合查询普通用户（不包含管理员）
	 * @param keyword
	 * @param enabled
	 * @param page
	 * @return
	 */
	List<User> queryUserListInCommonUser(String keyword, int enabled, Page page);
	
	/**
	 * 根据用户学校查询该用户所在学校的所有用户
	 * @param school	学校
	 * @return
	 */
	List<User> queryUserListBySchool(Long schoolId);
	
	/**
	 * 根据用户学校查询该用户所在学校的所有用户
	 * @param type		用户类型:::1-学生,2-老师,3-....
	 * @param schoolId	学校
	 * @return
	 */
	List<User> queryUserListBySchool(int type,Long schoolId);
	
	/**
	 * 根据用户编号查询用户
	 * @param ids
	 * @return
	 */
	List<User> queryUserByIds(String ids);
	
	/**
	 * 设置、修改用户头像
	 * @param user
	 * @return
	 */
	int setUserFace(User user);
	
	
	/**
	 * 查询所有用户
	 * @return
	 */
	List<User> queryAll();
	
	/**
	 * 根据用户Id查询用户信息
	 * @param userId
	 * @return
	 */
	User queryUserById(Long userId);
	
	
	/**
	 * 根据用户Id查询用户是否存在
	 * @param userId
	 * @return
	 */
	boolean queryIsUserById(Long userId);
	
	/**
	 * 重置密码
	 * @param user
	 * @return
	 */
	int updatePassWord(User user);
	
	/**
	 * 更新用户信息
	 * @param user
	 * @return
	 */
	int updateUser(User user);
	
}
