package edu.ecompus.cas.dao;

import edu.ecompus.cas.entity.Oauth2AccessToken;
import edu.ecompus.core.dao.ML2GenericDao;

/**
 * <B>TAB_OAUTH2_ACCESS_TOKEN</B> 数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-11 下午4:44:58
 */
public interface Oauth2AccessTokenDAO extends ML2GenericDao<Oauth2AccessToken> {
	/**
	 * 根据tokenValue查询访问令牌
	 * @param tokenValue
	 * @return
	 */
	Oauth2AccessToken queryAccessToken(String tokenValue);
	
	/**
	 * 根据authenticationId查询令牌
	 * @param authenticationId
	 * @return
	 */
	Oauth2AccessToken queryAccessTokenByAuthenticationId(String authenticationId);
	
	
	/**
	 * 删除令牌
	 * @param tokenId
	 */
	int deleteAccessToken(String tokenId);
	
	/**
	 * 删除令牌
	 * @param refreshToken
	 * @return
	 */
	int deleteAccessTokenUsingRefreshToken(String refreshToken);
}
