package edu.ecompus.cas.dao;

import java.util.List;

import edu.ecompus.cas.entity.District;
import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;
/**
 * <B>地区</B> 数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-7 下午5:18:34
 */
public interface DistrictDAO extends ML2GenericDao<District> {
	
	/**
	 * 通过codes查询地方
	 * @param ids	区域编号(以逗号的形式隔开)
	 * @return
	 */
	List<District> queryDistrictListByIds(String ids);
	
	
	/**
     * 查询所有省
     * 
     * @return
     */
    List<District> queryAllProvince();
    
    /**
     * 查询所有的城市
     * @return
     */
    List<District> queryAllCitys();
    
    /**
     * 查询省份所有城市
     * @param province
     * @return
     */
    List<District> queryCityList(Long provinceId);
    
    /**
	 * 根据省和名称模糊查询市
	 * @param cityName	(空或者NULL不为条件)
	 * @param province	(NULL不为条件)
	 * @return
	 */
    List<District> queryCityFuzzy(String cityName, District province);
    
    
    /**
     * 查询某个市下的所有区县信息
     * 
     * @param city
     * @return
     */
    List<District> queryAreaList(Long cityId);
    
    
    /**
	 * 根据市和名称模糊查询市
	 * @param areaName	(空或者NULL不为条件)
	 * @param city		(NULL不为条件)
	 * @return
	 */
    List<District> queryAreaFuzzy(String areaName, District city);
    
    /**
     * 模糊查询District
     * @param name
     * @param level
     * @return
     */
    List<District> queryFuzzy(String name, int level);
    
    /**
     * 
     * @param parentId
     * @param level
     * @return
     */
    public List<District> queryAllDistrict(Long parentId, int level);
    
    /**
     * 查询热门城市
     * @param page
     * @return
     */
    public List<District> queryHotCitys(Page page);
}
