package edu.ecompus.cas.dao;

import java.util.List;

import edu.ecompus.cas.entity.Company;
import edu.ecompus.core.dao.ML2GenericDao;
import edu.ecompus.core.entity.Page;

/**
 * <b>单位</b> 数据持久类 操作接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-6 下午3:02:37
 */
public interface CompanyDAO extends ML2GenericDao<Company> {
	
	/**
	 * 创建学校
	 * @param company
	 */
	void creatCompany(Company company);

	/**
	 * 获取所有学校数据
	 * @return
	 */
	List<Company> queryCompanyList();
	
	/**
	 * 条件查询[幼儿园]学校表数据
	 * @param company
	 * @param province
	 * @param city
	 * @param area
	 * @return
	 */
	List<Company> queryCompanyListByKey(String companyName, int status, String province, String city, String area, Page page);
	
	/**
	 * 查询机构
	 * @param keyword		机构名称、联系人、...
	 * @param district		省、市、区
	 * @param classify		-1不为条件，(1000-幼儿园 1001-小学 1002-初中 1003-高中 1004-职教)
	 * @param status		-1不为条件，（2000-公办园所,2001-民办园所,2002-合作园所,2003-早教机构）
	 * @param page			null不分页
	 * @return
	 */
	List<Company> queryCompanyList(String keyword, String district, int classify, int status, Page page);
	
	/**
	 * [幼教云后台管理系统]验证开通幼儿园数据
	 * @param keyword		关键词(NULL不为条件,学校名称,学校别名,联系人,电话,网址 ,地址,邮编,邮箱)
	 * @param status		状态(-1不为条件,0-全部
	 * @param page			分页
	 * @return
	 */
	List<Company> queryCompanyListBySystem(String keyword, int status, Page page);
}
