/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.util;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.cfg.NamingStrategy;

public class ImprovedNamingStrategy
implements NamingStrategy,
Serializable {
    private static final long serialVersionUID = 6498883838045615577L;
    public static final NamingStrategy INSTANCE = new ImprovedNamingStrategy();

    public String classToTableName(String className) {
        return ImprovedNamingStrategy.addUnderscores(StringHelper.unqualify((String)className));
    }

    public String propertyToColumnName(String propertyName) {
        return ImprovedNamingStrategy.addUnderscores(StringHelper.unqualify((String)propertyName));
    }

    public String tableName(String tableName) {
        return ImprovedNamingStrategy.addUnderscores(tableName).toUpperCase();
    }

    public String columnName(String columnName) {
        return ImprovedNamingStrategy.addUnderscores(columnName);
    }

    protected static String addUnderscores(String name) {
        StringBuffer buf = new StringBuffer(name.replace('.', '_'));
        for (int i = 1; i < buf.length() - 1; ++i) {
            if (!Character.isLowerCase(buf.charAt(i - 1)) || !Character.isUpperCase(buf.charAt(i)) || !Character.isLowerCase(buf.charAt(i + 1))) continue;
            buf.insert(i++, '_');
        }
        return buf.toString().toLowerCase();
    }

    public String collectionTableName(String ownerEntity, String ownerEntityTable, String associatedEntity, String associatedEntityTable, String propertyName) {
        return this.tableName(ownerEntityTable + '_' + this.propertyToColumnName(propertyName));
    }

    public String joinKeyColumnName(String joinedColumn, String joinedTable) {
        return this.columnName(joinedColumn);
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        String header;
        String string = header = propertyName != null ? StringHelper.unqualify((String)propertyName) : propertyTableName;
        if (header == null) {
            throw new AssertionFailure("NamingStrategy not properly filled");
        }
        return this.columnName(header);
    }

    public String logicalColumnName(String columnName, String propertyName) {
        return StringHelper.isNotEmpty((String)columnName) ? columnName : StringHelper.unqualify((String)propertyName);
    }

    public String logicalCollectionTableName(String tableName, String ownerEntityTable, String associatedEntityTable, String propertyName) {
        if (tableName != null) {
            return tableName;
        }
        return new StringBuffer(ownerEntityTable).append("_").append(associatedEntityTable != null ? associatedEntityTable : StringHelper.unqualify((String)propertyName)).toString();
    }

    public String logicalCollectionColumnName(String columnName, String propertyName, String referencedColumn) {
        return StringHelper.isNotEmpty((String)columnName) ? columnName : StringHelper.unqualify((String)propertyName) + "_" + referencedColumn;
    }
}

