/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.service.impl;

import edu.ecompus.cas.dao.UserBindDAO;
import edu.ecompus.cas.entity.UserBind;
import edu.ecompus.cas.service.UserBindService;
import edu.ecompus.core.service.GenerateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="userBindService")
public class UserBindServiceImpl
extends GenerateService
implements UserBindService {
    @Autowired
    UserBindDAO userBindDAO;

    @Override
    @CacheEvict(value={"default"}, key="'UserBind-cachebySchool_' + #userBind.schoolId + '_WX' + #userBind.winxinID")
    public UserBind addUserBind(UserBind userBind) {
        this.userBindDAO.create(userBind);
        return userBind;
    }

    @Override
    @CacheEvict(value={"default"}, key="'UserBind-cachebySchool_' + #userBind.schoolId + '_WX' + #userBind.winxinID")
    public void updateUserBind(UserBind userBind) {
        this.userBindDAO.update(userBind);
    }

    @Override
    @Cacheable(value={"default"}, key="'UserBind-cachebyU_' + #userId + '_S' + #schoolId")
    public UserBind getUserBind(Long userId, Long schoolId) {
        if (userId == null || schoolId == null) {
            return null;
        }
        return this.userBindDAO.queryUserBind(userId, schoolId, null, null, null);
    }

    @Override
    @CacheEvict(value={"default"}, key="'UserBind-cachebyU_' + #userId + '_S' + #schoolId")
    public void clearUserBindByuserId(Long userId, Long schoolId) {
    }

    @Override
    @Cacheable(value={"default"}, key="'UserBind-cachebySchool_' + #schoolId + '_WX' + #winxinID")
    public UserBind getUserBindByWeixinId(String winxinID, Long schoolId) {
        if (winxinID == null || "".equals(winxinID) || schoolId == null || schoolId == 0L) {
            return null;
        }
        return this.userBindDAO.queryUserBind(null, schoolId, winxinID, null, null);
    }

    @Override
    @CacheEvict(value={"default"}, key="'UserBind-cachebySchool_' + #schoolId + '_WX' + #winxinID")
    public void clearUserBindByWeixinCache(String winxinID, Long schoolId) {
    }

    @Override
    @CacheEvict(value={"default"}, key="'UserBind-cachebyU_' + #ub.userId + '_WX' + #ub.winxinID")
    public void clearUserBindByWeixinId(UserBind ub) {
        if (ub != null) {
            ub.setWinxinID(null);
            this.userBindDAO.update(ub);
        }
    }

    @Override
    public UserBind getUserBind(Long userId, Long schoolId, String winxinID, String qqId, String sinaId) {
        return this.userBindDAO.queryUserBind(userId, schoolId, winxinID, qqId, sinaId);
    }

    @Override
    @Cacheable(value={"default"}, key="'UserBind-cachebyWXOpenId-' + #openId")
    public UserBind getUserBindByWXOpenId(String openId) {
        if (openId != null && !"".equals(openId)) {
            return this.userBindDAO.queryUserBind(null, null, openId, null, null);
        }
        return null;
    }

    @Override
    @CacheEvict(value={"default"}, key="'UserBind-cachebyWXOpenId-' + #openId")
    public void clearUserBindByWXOpenId(String openId) {
    }

    @Override
    public void deleteUserBind(UserBind userBind) {
        this.userBindDAO.delete(userBind);
    }

    @Override
    @Cacheable(value={"default"}, key="'UserBind-cachebyQQ-' + #qq")
    public UserBind getUserBindByQQ(String qq) {
        if (qq != null && !"".equals(qq)) {
            return this.userBindDAO.queryUserBind(null, null, null, qq, null);
        }
        return null;
    }

    @Override
    @CacheEvict(value={"default"}, key="'UserBind-cachebyQQ-' + #qq")
    public void clearUserBindByQQ(String qq) {
    }

    @Override
    @Cacheable(value={"default"}, key="'UserBind-cachebyQQ-' + #weibo")
    public UserBind getUserBindByWeiBo(String weibo) {
        if (weibo != null && !"".equals(weibo)) {
            return this.userBindDAO.queryUserBind(null, null, null, null, weibo);
        }
        return null;
    }

    @Override
    @CacheEvict(value={"default"}, key="'UserBind-cachebyQQ-' + #weibo")
    public void clearUserBindByWeiBo(String weibo) {
    }
}

