/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.service.impl;

import edu.ecompus.cas.dao.DistrictDAO;
import edu.ecompus.cas.entity.District;
import edu.ecompus.cas.service.DistrictService;
import edu.ecompus.core.service.GenerateService;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="distictService")
public class DistrictServiceImpl
extends GenerateService
implements DistrictService {
    @Autowired
    DistrictDAO districtDAO;

    @Override
    public District addDistrict(District district) {
        this.districtDAO.create(district);
        return district;
    }

    @Override
    @CacheEvict(value={"DISTRICT"}, key="'district-cache-by' + #district.id")
    public void updateDistrict(District district) {
        this.districtDAO.update(district);
    }

    @Override
    @Cacheable(value={"DISTRICT"}, key="'district-cache-by' + #id")
    public District getDistrictById(Long id) {
        if (id != null && id > 0L) {
            return (District)this.districtDAO.query(id);
        }
        return null;
    }

    @Override
    @Cacheable(value={"DISTRICT"}, key="'district-provincelist'")
    public List<District> getAllProvince() {
        return this.districtDAO.queryAllProvince();
    }

    @Override
    @CacheEvict(value={"DISTRICT"}, key="'district-provincelist'")
    public void clearAllProvinceCache() {
    }

    @Override
    @Cacheable(value={"DISTRICT"}, key="'district-citylist-p' + #provinceId ")
    public List<District> getCityList(Long provinceId) {
        return this.districtDAO.queryCityList(provinceId);
    }

    @Override
    public List<District> getDistrictListByIds(String ids) {
        return this.districtDAO.queryDistrictListByIds(ids);
    }

    @Override
    @Cacheable(value={"DISTRICT"}, key="'district-arealist-c' + #cityId ")
    public List<District> getAreaList(Long cityId) {
        return this.districtDAO.queryAreaList(cityId);
    }

    @Override
    @Cacheable(value={"DISTRICT"}, key="'DistrictList-byname' + #name + '-lvl' + #level ")
    public List<District> getFuzzy(String name, int level) {
        if (name != null && !"".equals(name)) {
            return this.districtDAO.queryFuzzy(name, level);
        }
        return Collections.emptyList();
    }

    @Override
    @Cacheable(value={"DISTRICT"}, key="'District-byname' + #name + '-lvl' + #level ")
    public District getDistrictFuzzy(String name, int level) {
        List<District> list = this.getFuzzy(name, level);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    @Cacheable(value={"DISTRICT"}, key="'District-AllCitys' ")
    public List<District> getAllCitys() {
        return this.districtDAO.queryAllCitys();
    }

    @Override
    @CacheEvict(value={"DISTRICT"}, key="'District-AllCitys' ")
    public void clearAllCitysCache() {
    }

    @Override
    public List<District> getAllDistrict(Long parentId, int level) {
        return this.districtDAO.queryAllDistrict(parentId, level);
    }

    @Override
    @CacheEvict(value={"DISTRICT"}, allEntries=true)
    public void clearDistrictCache() {
    }

    @Override
    public int deleteDistrict(List<District> districtList) {
        if (districtList != null && districtList.size() > 0) {
            District district = null;
            int deleteCount = 0;
            for (int i = 0; i < districtList.size(); ++i) {
                district = districtList.get(i);
                if (district == null) continue;
                this.districtDAO.delete(district);
                ++deleteCount;
            }
            return deleteCount;
        }
        return 0;
    }
}

