/*
 * Decompiled with CFR 0.152.
 */
package edu.ecompus.cas.mail;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class VelocityMailService
extends JavaMailSenderImpl
implements JavaMailSender {
    private Properties mailHeaders = new Properties();
    private String from;
    private String subject;
    private String templateName;
    private ArrayList<String> userNameList;
    private ArrayList<String> passwordList;
    private int currentMailId = 0;
    private ArrayList<String> mutiUser;
    private Map<String, Object> attachments;
    private Map<String, Object> inlines;
    @Autowired
    private VelocityEngine velocityEngine;
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private JavaMailSender meMailSender;

    public String renderText(Map model) throws VelocityException {
        return VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.getVelocityEngine(), (String)this.getTemplateName(), (String)"utf-8", (Map)model);
    }

    public Properties getMailHeaders() {
        return this.mailHeaders;
    }

    public boolean sendMime(String nameOfTo, String emailOfTo, Map<String, Object> model) {
        try {
            return this.sendMime(nameOfTo + "<" + emailOfTo + ">", model);
        }
        catch (MailException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean sendMime(String to, Map<String, Object> model) {
        try {
            return this.sendMime(this.mergeSimpleMessage(to, model));
        }
        catch (MailException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean sendMime(SimpleMailMessage simpleMessage) {
        try {
            this.mailSender.send(this.toMimeMessage(simpleMessage));
            return true;
        }
        catch (MailException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean sendMail(Map<String, Object> model) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            String text = null;
            try {
                text = this.renderText(model);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
            helper.setSubject(this.getSubject());
            helper.setFrom(this.getFrom());
            helper.setText(text, true);
            if (this.inlines != null && this.inlines.size() > 0) {
                for (String inline : this.inlines.keySet()) {
                    File inlineFile = (File)this.inlines.get(inline);
                    helper.addInline(inline, inlineFile);
                }
            }
            if (this.inlines != null && this.attachments.size() > 0) {
                for (String attachment : this.attachments.keySet()) {
                    File attachmentFile = (File)this.attachments.get(attachment);
                    helper.addAttachment(attachment, attachmentFile);
                }
            }
            if (this.mutiUser != null && this.mutiUser.size() > 0) {
                InternetAddress[] to_mail = new InternetAddress[this.mutiUser.size()];
                for (int i = 0; i < this.mutiUser.size(); ++i) {
                    to_mail[i] = new InternetAddress(this.mutiUser.get(i));
                }
                helper.setTo(to_mail);
            }
            this.mailSender.send(message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setMailHeaders(Properties mailHeaders) {
        this.mailHeaders = mailHeaders;
    }

    public String getFrom() {
        return this.from;
    }

    public Address getFromAddress() throws AddressException {
        return new InternetAddress(this.from);
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public JavaMailSender getJavaMailSender() {
        return this.mailSender;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setUsername(String username) {
        String[] userNames;
        if (this.userNameList == null) {
            this.userNameList = new ArrayList();
        }
        if ((userNames = username.split(",")) != null) {
            for (String user : userNames) {
                this.userNameList.add(user);
            }
        }
        super.setUsername(this.userNameList.get(this.currentMailId));
    }

    public void setPassword(String password) {
        String[] passwords;
        if (this.passwordList == null) {
            this.passwordList = new ArrayList();
        }
        if ((passwords = password.split(",")) != null) {
            for (String pw : passwords) {
                this.passwordList.add(pw);
            }
        }
        super.setPassword(this.passwordList.get(this.currentMailId));
    }

    protected void doSend(MimeMessage[] mimeMessage, Object[] object) throws MailException {
        super.doSend(mimeMessage, object);
        this.currentMailId = (this.currentMailId + 1) % this.userNameList.size();
        super.setUsername(this.userNameList.get(this.currentMailId));
        super.setPassword(this.passwordList.get(this.currentMailId));
    }

    public SimpleMailMessage mergeSimpleMessage(String to, Map<String, Object> model) {
        String text = null;
        try {
            text = this.renderText(model);
        }
        catch (VelocityException e) {
            e.printStackTrace();
        }
        SimpleMailMessage message = new SimpleMailMessage();
        message.setSubject(this.getSubject());
        message.setFrom(this.getFrom());
        message.setTo(to);
        message.setText(text);
        return message;
    }

    public MimeMessagePreparator toMimeMessage(final SimpleMailMessage simpleMailMessage) {
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
                message.setTo(simpleMailMessage.getTo());
                message.setSubject(simpleMailMessage.getSubject());
                message.setText(simpleMailMessage.getText(), true);
                message.setFrom(simpleMailMessage.getFrom());
            }
        };
        return preparator;
    }

    public void addAttachments(String attachmentFilename, File file) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Object>();
        }
        if (attachmentFilename == null || "".equals(attachmentFilename)) {
            return;
        }
        if (file == null) {
            return;
        }
        this.attachments.put(attachmentFilename, file);
    }

    public void addAttachmentsList(Map<String, Object> files) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Object>();
        }
        this.attachments.putAll(files);
    }

    public void addInlines(String attachmentFilename, File file) {
        if (this.inlines == null) {
            this.inlines = new HashMap<String, Object>();
        }
        if (attachmentFilename == null || "".equals(attachmentFilename)) {
            return;
        }
        if (file == null) {
            return;
        }
        this.inlines.put(attachmentFilename, file);
    }

    public void addInlinesList(Map<String, Object> files) {
        if (this.inlines == null) {
            this.inlines = new HashMap<String, Object>();
        }
        this.inlines.putAll(files);
    }

    public void addToUser(String userMail) {
        if (this.mutiUser == null) {
            this.mutiUser = new ArrayList();
        }
        this.mutiUser.add(userMail);
    }

    public void addUserList(List<String> mutiUser) {
        if (this.mutiUser == null) {
            this.mutiUser = new ArrayList();
        }
        this.mutiUser.clear();
        this.mutiUser.addAll(mutiUser);
    }

    public boolean sendMeMail(Map<String, Object> model) {
        try {
            MimeMessage message = this.meMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            String text = null;
            try {
                text = this.renderText(model);
            }
            catch (VelocityException e) {
                e.printStackTrace();
            }
            helper.setSubject(this.getSubject());
            helper.setFrom(this.getFrom());
            helper.setText(text, true);
            if (this.inlines != null && this.inlines.size() > 0) {
                for (String inline : this.inlines.keySet()) {
                    File inlineFile = (File)this.inlines.get(inline);
                    helper.addInline(inline, inlineFile);
                }
            }
            if (this.inlines != null && this.attachments.size() > 0) {
                for (String attachment : this.attachments.keySet()) {
                    File attachmentFile = (File)this.attachments.get(attachment);
                    helper.addAttachment(attachment, attachmentFile);
                }
            }
            if (this.mutiUser != null && this.mutiUser.size() > 0) {
                InternetAddress[] to_mail = new InternetAddress[this.mutiUser.size()];
                for (int i = 0; i < this.mutiUser.size(); ++i) {
                    to_mail[i] = new InternetAddress(this.mutiUser.get(i));
                }
                helper.setTo(to_mail);
            }
            this.meMailSender.send(message);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

