package edu.ecompus.cas.web;


import java.net.URLDecoder;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.service.CompanyService;
import edu.ecompus.cas.service.UserService;
import edu.ecompus.core.util.CookieUtil;


/**
 * 
 * 统一权限管理
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-7-15 下午3:59:37
 */
public class WebCompus {
		
	/**
	 * 当前用户Session Key
	 */
	private static final String USERID_KEY = "cas_$user_id";
	
	/**
	 * 当前用户所在学校Session Key
	 */
	private static final String SCHOOLID_KEY = "cas_$school_id";
	
	/**
	 * 当前用户是否显示帮助
	 */
	public static final String USERSHOWHELP_KEY = "cas_$showhelp";
	
	/**COOKIE保存的用户名**/
	public static String COOKIE_LOGIN_USERNAME = "cas_$CNAME";
	/**COOKIE保存的密码**/
	public static String COOKIE_LOGIN_PASSWORD = "cas_$CPSW";
	
	/**
	 * 登录退出
	 * @param request
	 */
	public static void loginOut(HttpServletRequest req){
		if(req!=null && req.getSession()!=null){
			req.getSession().removeAttribute(USERID_KEY);
		}
	}
	
	/**
	 * 从缓存获取当前用户编号
	 * 
	 * @param req
	 * @return    current login user
	 */
	public static Long getCurrentUserId(HttpServletRequest req) {
		return  (Long) req.getSession().getAttribute(USERID_KEY);
	}
	
	/**
	 * 从缓存获取当前用户
	 * 
	 * @param req
	 * @return    current login user
	 */
	public static User getCurrentUser(UserService userService, HttpServletRequest req) {
		Long userId = (Long) req.getSession().getAttribute(USERID_KEY);
		if(userId!=null && userId>0){
			return userService.getUserByUserId(userId);
		}
		
		return null;
	}
	
	/**
	 * 从缓存获取当前学校
	 * @param req
	 * @return
	 */
	public static Company getCurrentCompany(CompanyService companyService, HttpServletRequest req){
		Long schoolId = (Long) req.getSession().getAttribute(SCHOOLID_KEY);
		if(schoolId!=null && schoolId>0){
			return companyService.getCompany(schoolId);
		}
		
		return null;
	}
	
	/**
	 * 从缓存获取当前学校编号
	 * @param req
	 * @return
	 */
	public static Long getCurrentCompanyId(HttpServletRequest req){
		return (Long) req.getSession().getAttribute(SCHOOLID_KEY);
	}
	
	
	/**
	 * 保存用户到Session <b>USERID_KEY</b>
	 * 
	 * @param req
	 * @param user          the login user
	 */
	public static void setCurrentUser(HttpServletRequest req, Long userId) {
		req.getSession().setAttribute(USERID_KEY, userId);
	}
	
	/**
	 * 保存用户所在学校到Session <b>USERID_KEY</b>
	 * 
	 * @param req
	 * @param user          the login user
	 */
	public static void setCurrentCompanyId(HttpServletRequest req, Long companyId) {
		req.getSession().setAttribute(SCHOOLID_KEY, companyId);
	}
	
	/**
	 * 读取保存在Session里面的对象
	 * @param req
	 * @param sessionKey
	 * @return
	 */
	public static Object getSessionAttrib(HttpServletRequest req, String sessionKey) {
		return req.getSession().getAttribute(sessionKey);
	}
	
	/**
	 * 将对象保存到Session里面
	 * @param req
	 * @param sessionKey
	 * @param object
	 */
	public static void setSessionAttrib(HttpServletRequest req, String sessionKey, Object object ){
		req.getSession().setAttribute(sessionKey, object);
	}

	/**
	 * 删除Session里面的对象
	 * @param request
	 * @param sessionKey
	 */
	public static void deleteSessionAttrib(HttpServletRequest request,
			String sessionKey) {
		Object obj = getSessionAttrib(request, sessionKey);
		if(obj!=null){
			obj=null;
		}
	}
	
	/**
	 * 清除缓存
	 */
	public static void logout(HttpServletRequest request, HttpServletResponse response){
		//清除Cookie
		Cookie usernameCookie = CookieUtil.getCookie(request, COOKIE_LOGIN_USERNAME);
		if(usernameCookie!=null){
			CookieUtil.deleteCookie(request, response, usernameCookie);
		}
		
		Cookie passwordCookie = CookieUtil.getCookie(request, COOKIE_LOGIN_PASSWORD);
		if(passwordCookie!=null){
			CookieUtil.deleteCookie(request, response, passwordCookie);
		}
		//清除用户ID
		request.getSession().removeAttribute(USERID_KEY);
		
		//
	}
	
	/**
	 * 从Cookie读取用户名
	 * @param schoolId
	 * @param request
	 * @return
	 */
	public static String getCookie_UserName(HttpServletRequest request){
		Cookie usernameCookie = CookieUtil.getCookie(request, COOKIE_LOGIN_USERNAME);
		if(usernameCookie!=null){
			try{
				return URLDecoder.decode(usernameCookie.getValue(),"utf-8");
			}catch(Exception e){}
			
		}
		
		return "";
	}
	
	/**
	 * 从Cookie读取密码
	 * @param schoolId
	 * @param request
	 * @return
	 */
	public static String getCookie_Password(HttpServletRequest request){
		Cookie passwordCookie = CookieUtil.getCookie(request, COOKIE_LOGIN_PASSWORD);
		if(passwordCookie!=null){
			return passwordCookie.getValue();
		}
		
		return "";
	}
	
	
}
