package edu.ecompus.cas.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

import javax.servlet.http.HttpServletRequest;

/**
 * 网页下载工具类
 * 
 * 
 * CopyRright (c) 2013: <紫悦新橙> Project: <数字化校园 > Module ID:
 * <(模块)类编号，可以引用系统设计中的类编号> Comments: <对此类的描述，可以引用系统设计中的描述> JDK version used:
 * <JDK1.6>
 * 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-11-7 下午4:09:35
 */
public class WebGetUtil {
	/**
	 * 保存远程路径地址为本地文件
	 * 
	 * @param photoUrl
	 * @param fileName
	 * @return
	 */
	public static boolean saveUrlAs(String remoteFilePath, String localFilePath) {
		boolean flag = false;
		URL urlfile = null;
		HttpURLConnection httpUrl = null;
		BufferedInputStream bis = null;
		BufferedOutputStream bos = null;
		File f = new File(localFilePath);
		try {
			urlfile = new URL(remoteFilePath);
			httpUrl = (HttpURLConnection) urlfile.openConnection();
			httpUrl.connect();
			bis = new BufferedInputStream(httpUrl.getInputStream());
			bos = new BufferedOutputStream(new FileOutputStream(f));
			int len = 2048;
			byte[] b = new byte[len];
			while ((len = bis.read(b)) != -1) {
				bos.write(b, 0, len);
			}
			bos.flush();
			bis.close();
			httpUrl.disconnect();

			flag = true;
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				bis.close();
				bos.close();
			} catch (IOException e) {
			}

		}

		return flag;
	}

	public static String getDocumentAt(String urlString) {
		// 此方法兼容HTTP和FTP协议
		StringBuffer document = new StringBuffer();
		try {
			URL url = new URL(urlString);
			URLConnection conn = url.openConnection();
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					conn.getInputStream()));
			String line = null;
			while ((line = reader.readLine()) != null) {
				document.append(line + "\n");
			}
			reader.close();
		} catch (MalformedURLException e) {
			System.out.println("Unable to connect to URL: " + urlString);
			e.printStackTrace();
		} catch (IOException e) {
			System.out.println("IOException when connecting to URL: "
					+ urlString);
			e.printStackTrace();
		}
		return document.toString();
	}

	/**
	 * 读取请求IP地址
	 * 
	 * @param request
	 * @return
	 */
	public static String getIpAddr(HttpServletRequest request) {
		String ip = request.getHeader("x-forwarded-for");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		return ip;
	}

	/**
	 * 读取请求IP地址(简单)
	 * 
	 * @param request
	 * @return
	 */
	public static String getRemortIP(HttpServletRequest request) {
		if (request.getHeader("x-forwarded-for") == null) {
			return request.getRemoteAddr();
		}
		return request.getHeader("x-forwarded-for");
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		String photoUrl = "http://d.hiphotos.baidu.com/album/w%3D2048/sign=4bc6cfa28718367aad8978dd1a4b8ad4/09fa513d269759eec6fa6240b3fb43166c22df97.jpg";
		String filePath = "d:\\test.jpg";
		WebGetUtil.saveUrlAs(photoUrl, filePath);
		// TODO Auto-generated method stub

	}

}
