package edu.ecompus.cas.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

/**
 * Url地址验证器
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-11-18 下午3:16:53
 */
public class UrlMatcherUtil {
	/***
	 * 日志
	 */
	private static final Logger logger = LoggerFactory.getLogger(UrlMatcherUtil.class);
	
	/**
	 * 正则工具
	 */
	private static AntPathMatcher urlMatcher = new AntPathMatcher();
	
	
	/**
	 * 判断请求的信息是否匹配
	 * @param url	权限地址
	 * @param req	请求
	 * @return
	 */
	public static boolean hasMather(String url, HttpServletRequest req){
		String requestUrl = req.getServletPath();
		if(requestUrl.indexOf("?")!=-1) {
    		requestUrl = requestUrl.substring(0, requestUrl.indexOf("?"));
    	}
		
		return hasMather(url,requestUrl);
	}
	
	/**
	 * 
	 * @param url
	 * @param requestUrl
	 * @return
	 */
	public static boolean hasMather(String url, String requestUrl){
		//是否存在权限
		boolean match = false;
		if(url!=null && !StringUtil.isEmpty(url)){
			//Pattern p = Pattern.compile("(?<=http://|\\.)[^.]*?\\.(com|cn|net|org|biz|info|cc|tv)",Pattern.CASE_INSENSITIVE);
			//Matcher matcher = p.matcher(url);
			//if(matcher.find()){
			//	System.out.println(matcher.group()); 
			//	match = urlMatcher.match(requestUrl,matcher.group()+"/**");
			//}
			match = urlMatcher.match(url+"/**",requestUrl);
			
			if(logger.isInfoEnabled()){
				logger.info(String.format("权限[%s]--请求来源地址[%s]=%s",url+"/**", requestUrl, match));
			}
			if(match){	//验证true,表示有权限,若是false,继续遍历
				return true;
			}
		}
		
		return match;
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		System.out.println("1.hasMather="+hasMather("http://www.36uk.com/loginsuccess.php","http://www.36uk.com/loginsuccess.php"));
		
		System.out.println("2.hasMather="+hasMather("http://www.36uk.cn/thirdparty/uk/success/**","http://www.36uk.cn/thirdparty/uk/success/**"));
	}

}
