package edu.ecompus.cas.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import net.sf.json.JSONObject;

import edu.ecompus.cas.module.so.AddressIpSO;

/**
 * 根据IP地址获取详细的地域信息
 * 
 * 
 * @CopyRight CopyRright (c) 2013: <紫悦新橙> Project: <数字化校园 > Module ID:
 *            <(模块)类编号，可以引用系统设计中的类编号> Comments: <对此类的描述，可以引用系统设计中的描述> JDK
 *            version used: <JDK1.6>
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-1-21 上午11:25:52
 */
public class AddressUtils {

	/**
	 * 根据IP通过淘宝IP库查询地址
	 * 
	 * @param IP
	 * @return
	 */
	public static AddressIpSO GetAddressByTaobao(String IP) {
		AddressIpSO ipso = new AddressIpSO();
		try {
			String str = getJsonContent("http://ip.taobao.com/service/getIpInfo.php?ip=" + IP);
			//System.out.println(str);
			//转换格式
			JSONObject obj = JSONObject.fromObject(str);
			//转换数据格式
			JSONObject obj2 = (JSONObject) obj.get("data");
			//返回结果
			String code = String.valueOf(obj.get("code"));
			ipso.setIp(IP);
			if (code.equals("0")) {
				ipso.setArea(String.valueOf(obj2.get("area")));
				ipso.setArea_id(String.valueOf(obj2.get("area_id")));
				ipso.setCity(String.valueOf(obj2.get("city")));
				ipso.setCity_id(String.valueOf(obj2.get("city_id")));
				ipso.setCountry(String.valueOf(obj2.get("country")));
				ipso.setCountry_id(String.valueOf(obj2.get("country_id")));
				ipso.setCounty(String.valueOf(obj2.get("county")));
				ipso.setCounty_id(String.valueOf(obj2.get("county_id")));
				ipso.setIsp(String.valueOf(obj2.get("isp")));
				ipso.setIsp_id(String.valueOf(obj2.get("isp_id")));
				ipso.setRegion(String.valueOf(obj2.get("region")));
				ipso.setRegion_id(String.valueOf(obj2.get("region_id")));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ipso;
	}
	
	/**
	 * 根据IP通过新浪IP库查询地址
	 * 
	 * @param IP
	 * @return
	 */
	public static AddressIpSO GetAddressBySina(String IP) {
		/**
		 * //{"ret":1,"start":"218.192.0.0","end":"218.192.7.255",
		 * 		"country":"\u4e2d\u56fd",
		 * 		"province":"\u5e7f\u4e1c",
		 * 		"city":"\u5e7f\u5dde",
		 * 		"district":"",
		 * 		"isp":"\u6559\u80b2\u7f51",
		 * 		"type":"\u5b66\u6821",
		 * 		"desc":"\u5e7f\u5dde\u5927\u5b66\u7eba\u7ec7\u670d\u88c5\u5b66\u9662\u6559\u80b2\u7f51"}
		 */
		AddressIpSO ipso = new AddressIpSO();
		try {
			String str = getJsonContent("http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=json&ip=" + IP);
			//System.out.println(str);
			//转换格式
			JSONObject obj = JSONObject.fromObject(str);
			//返回结果
			String code = String.valueOf(obj.get("ret"));
			ipso.setIp(IP);
			if (code.equals("1")) {
				ipso.setCountry(String.valueOf(obj.get("country")));
				ipso.setRegion(String.valueOf(obj.get("province")));
				ipso.setCity(String.valueOf(obj.get("city")));
				ipso.setArea(String.valueOf(obj.get("district")));
				ipso.setIsp(String.valueOf(obj.get("isp")));
				ipso.setType(String.valueOf(obj.get("type")));
				ipso.setDesc(String.valueOf(obj.get("desc")));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ipso;
	}

	/**
	 * 通过URL Get数据
	 * 
	 * @param urlStr
	 * @return
	 */
	public static String getJsonContent(String urlStr) {
		try {// 获取HttpURLConnection连接对象
			URL url = new URL(urlStr);
			HttpURLConnection httpConn = (HttpURLConnection) url
					.openConnection();
			// 设置连接属性
			httpConn.setConnectTimeout(3000);
			httpConn.setDoInput(true);
			httpConn.setRequestMethod("GET");
			// 获取相应码
			int respCode = httpConn.getResponseCode();
			if (respCode == 200) {
				return ConvertStream2Json(httpConn.getInputStream());
			}
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return "";
	}

	/**
	 * 将输出流转换为JSON字符串格式
	 * 
	 * @param inputStream
	 * @return
	 */
	private static String ConvertStream2Json(InputStream inputStream) {
		String jsonStr = "";
		// ByteArrayOutputStream相当于内存输出流
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		byte[] buffer = new byte[1024];
		int len = 0;
		// 将输入流转移到内存输出流中
		try {
			while ((len = inputStream.read(buffer, 0, buffer.length)) != -1) {
				out.write(buffer, 0, len);
			}
			// 将内存流转换为字符串
			jsonStr = new String(out.toByteArray());
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return jsonStr;
	}
	
	 // 测试  
	 public static void main(String[] args) {  
		  // 测试ip 219.136.134.157 中国=华南=广东省=广州市=越秀区=电信  
		  System.out.println(AddressUtils.GetAddressByTaobao("125.70.11.136"));  
		  System.out.println(AddressUtils.GetAddressBySina("125.120.156.225"));
		  
	 }  

}
