/****************************************************************
文件名称:UserServiceImpl.java                                                
项目名称: E-Compus CAS                                              
模块名称:                                                          
功能说明:                                                          
系统版本: 1.0                                                   
开发人员: 王树辉                                                                                                                                                  
开发时间: 2013-11-18 下午4:58:11                                     
相关文档:                                                          
 *****************************************************************/
package edu.ecompus.cas.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.cas.dao.UserDAO;
import edu.ecompus.cas.dao.UserLoginLogDAO;
import edu.ecompus.cas.dao.UserRoleDAO;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserLoginLog;
import edu.ecompus.cas.entity.UserRole;
import edu.ecompus.cas.service.UserService;
import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;

/**
 * <b>学校</b> 服务层接口实现
 * 
 * 
 * CopyRright (c) 2013: <紫悦新橙> Project: <数字化校园 > Module ID:
 * <(模块)类编号，可以引用系统设计中的类编号> Comments: <对此类的描述，可以引用系统设计中的描述> JDK version used:
 * <JDK1.6>
 * 
 * @author wsh
 * @since Date： 2013-8-6 下午3:15:59
 */
@Service("userService")
public class UserServiceImpl extends GenerateService implements UserService {
	/**
	 * CAS||学校-DAO
	 */
	@Autowired
	UserDAO userDAO;

	@Autowired
	UserLoginLogDAO userLoginLogDAO;
	
	/**
	 * 用户角色-DAO
	 */
	@Autowired
	UserRoleDAO userRoleDao;
	
	@CachePut(value="default",key="'usercachebykey_un' + #user.username")
	@Override
	public User addUser(User user) {
		if (user != null) {
			this.userDAO.create(user);
			return user;
		}
		
		return null;
	}
	
	@Override
	public User getUser(String userName, String nickName) {
		if (userName != null && !"".equals(userName)) {
			return userDAO.getUser(userName);
		}
		
		if(nickName!=null && !"".equals(nickName)){
			return userDAO.getUserByNickName(nickName);
		}
		
		
		return null;
	}
	
	@Cacheable(value="default",key="'usercachebykey_un' + #userName")
	@Override
	public User getUserByUserName(String userName) {
		if (userName != null && !"".equals(userName)) {
			return userDAO.getUser(userName);
		}
		return null;
	}
	
	@Override
	public User getUserByUserNameNoCache(String userName) {
		if (userName != null && !"".equals(userName)) {
			return userDAO.getUser(userName);
		}
		return null;
	}
	
	@CacheEvict(value="default",key="'usercachebykey_un' + #userName")
	@Override
	public void clearUserByUserNameCache(String userName) {
		// 
	}

	
	@Cacheable(value="default",key="'usercachebykey_' + #userId")
	@Override
	public User getUserByUserId(Long userId) {
		if (userId != null) {
			return userDAO.queryUserById(userId);
		}
		return null;
	}

	@Override
	public List<User> getUserList(String username, int enable, Page page) {
		return userDAO.queryUserList(username, null, enable, null, null, page);
	}

	@CacheEvict(value="default",key="'usercachebykey_' + #user.id")
	@Override
	public void updateUser(User user) {
		userDAO.update(user);
	}

	@Cacheable(value="default",key="'UserLoginCount-cache-by-user' + #userId")
	@Override
	public Long countLogin(Long userId) {
		return userLoginLogDAO.countLogin(userId);
	}

	
	
	
	@Cacheable(value="default",key="'UserRoleList-cache-by-user' + #user.id")
	@Override
	public List<UserRole> getUserRoleList(User user) {
		if(user==null){
			return Collections.emptyList();
		}
		
		return userRoleDao.queryUserRoleList(user.getId());
	}

	@Override
	public UserLoginLog addUserLoginLog(UserLoginLog userLoginLog) {
		userLoginLogDAO.create(userLoginLog);
		return userLoginLog;
	}

	@Override
	public void AddUserLoginLog(String ip, Long userId) {
		UserLoginLog log = new UserLoginLog();
		log.setLoginDate(new Date());
		log.setLoginIp(ip);
		log.setUserId(userId);
		addUserLoginLog(log);
	}

	@Override
	public List<User> getUserByIds(String ids) {
		if(ids==null || "".equals(ids))
		{
			return Collections.emptyList();
		}
		return userDAO.queryUserByIds(ids);
	}

	@Override
	public List<User> getUserList(int type, Long schoolId) {
		if(type==-1 || schoolId==null || schoolId<=0){
			return Collections.emptyList();
		}
		
		return userDAO.queryUserListBySchool(type, schoolId);
	}

	@Override
	public User getUserByNickName(String nickName) {
		if(nickName!=null && !"".equals(nickName)){
			return userDAO.getUserByNickName(nickName);
		}
		return null;
	}

	@Override
	public List<User> getUserList(String keyword, Long schoolId, int enabled,
			String mobile, String identity, Page page) {
		return userDAO.queryUserList(keyword, schoolId, enabled, mobile, 	identity, page);
	}


	

}
