package edu.ecompus.cas.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.cas.dao.UserBindDAO;
import edu.ecompus.cas.entity.UserBind;
import edu.ecompus.cas.service.UserBindService;
import edu.ecompus.core.service.GenerateService;
/**
 * 用户关系绑定 服务层 接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-7-10 下午5:21:30
 */
@Service("userBindService")
public class UserBindServiceImpl extends GenerateService implements
		UserBindService {
	
	@Autowired
	UserBindDAO userBindDAO;

	@CacheEvict(value="default",key="'UserBind-cachebySchool_' + #userBind.schoolId + '_WX' + #userBind.winxinID")
	@Override
	public UserBind addUserBind(UserBind userBind) {
		userBindDAO.create(userBind);
		return userBind;
	}

	@CacheEvict(value="default",key="'UserBind-cachebySchool_' + #userBind.schoolId + '_WX' + #userBind.winxinID")
	@Override
	public void updateUserBind(UserBind userBind) {
		userBindDAO.update(userBind);
	}
	
	@Cacheable(value="default",key="'UserBind-cachebyU_' + #userId + '_S' + #schoolId")
	@Override
	public UserBind getUserBind(Long userId, Long schoolId) {
		if(userId==null || schoolId==null){
			return null;
		}
		
		return userBindDAO.queryUserBind(userId, schoolId, null, null, null);
	}
	
	@CacheEvict(value="default",key="'UserBind-cachebyU_' + #userId + '_S' + #schoolId")
	@Override
	public void clearUserBindByuserId(Long userId, Long schoolId) {
		// TODO 根据userId与学校编号--清除绑定
	}

	@Cacheable(value="default",key="'UserBind-cachebySchool_' + #schoolId + '_WX' + #winxinID")
	@Override
	public UserBind getUserBindByWeixinId(String winxinID, Long schoolId) {
		if(winxinID==null || "".equals(winxinID) || schoolId==null || schoolId==0l){
			return null;
		}
		
		return userBindDAO.queryUserBind(null, schoolId, winxinID, null, null);
	}
	
	@CacheEvict(value="default",key="'UserBind-cachebySchool_' + #schoolId + '_WX' + #winxinID")
	@Override
	public void clearUserBindByWeixinCache(String winxinID, Long schoolId) {
		// TODO  清除微信缓存
	}

	@CacheEvict(value="default",key="'UserBind-cachebyU_' + #ub.userId + '_WX' + #ub.winxinID")
	@Override
	public void clearUserBindByWeixinId(UserBind ub) {
		if(ub!=null){
			ub.setWinxinID(null);
			userBindDAO.update(ub);
		}
	}


	@Override
	public UserBind getUserBind(Long userId, Long schoolId, String winxinID,
			String qqId, String sinaId) {
		return userBindDAO.queryUserBind(userId, schoolId, winxinID, qqId, sinaId);
	}

	@Cacheable(value="default",key="'UserBind-cachebyWXOpenId-' + #openId")
	@Override
	public UserBind getUserBindByWXOpenId(String openId) {
		if(openId!=null && !"".equals(openId)){
			return userBindDAO.queryUserBind(null, null, openId, null, null);
		}
		
		return null;
	}

	@CacheEvict(value="default",key="'UserBind-cachebyWXOpenId-' + #openId")
	@Override
	public void clearUserBindByWXOpenId(String openId) {
		// TODO 清除微信OpenId绑定用户缓存
	}

	@Override
	public void deleteUserBind(UserBind userBind) {
		userBindDAO.delete(userBind);
	}

	@Cacheable(value="default",key="'UserBind-cachebyQQ-' + #qq")
	@Override
	public UserBind getUserBindByQQ(String qq) {
		if(qq!=null && !"".equals(qq)){
			return userBindDAO.queryUserBind(null, null, null, qq, null);
		}
		
		return null;
	}

	@CacheEvict(value="default",key="'UserBind-cachebyQQ-' + #qq")
	@Override
	public void clearUserBindByQQ(String qq) {
		// TODO 清除QQ绑定用户缓存
	}

	@Cacheable(value="default",key="'UserBind-cachebyQQ-' + #weibo")
	@Override
	public UserBind getUserBindByWeiBo(String weibo) {
		if(weibo!=null && !"".equals(weibo)){
			return userBindDAO.queryUserBind(null, null, null, null, weibo);
		}
		return null;
	}

	@CacheEvict(value="default",key="'UserBind-cachebyQQ-' + #weibo")
	@Override
	public void clearUserBindByWeiBo(String weibo) {
		// TODO 清除Weibo绑定用户缓存
	}

	

	

	

}
