package edu.ecompus.cas.service.impl;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.cas.dao.RoleDAO;
import edu.ecompus.cas.dao.UserRoleDAO;
import edu.ecompus.cas.entity.Role;
import edu.ecompus.cas.entity.UserRole;
import edu.ecompus.cas.service.RoleService;
import edu.ecompus.core.service.GenerateService;

/**
 * <b>角色  </b> 服务层接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-10-25 下午2:56:45
 */
@Service("roleService")
public class RoleServiceImpl extends GenerateService implements RoleService {

	@Autowired
	RoleDAO roleDAO;
	
	/**
	 * 用户角色DAO
	 */
	@Autowired
	UserRoleDAO userRoleDAO;
	
	@Override
	public Role getRoleById(Long id) {
		return roleDAO.query(id);
	}

	@Override
	public List<Role> getRoleList() {
		return roleDAO.queryRoleAll();
	}

	@Override
	public UserRole addUserRole(UserRole userRole) {
		userRoleDAO.create(userRole);
		return userRole;
	}

	@CacheEvict(value="default",key="'UserRole-byid_' + #userRole.id")
	@Override
	public void updateUserRole(UserRole userRole) {
		userRoleDAO.update(userRole);
		//清除用户角色缓存列表 clearUserRoleCache
		if(userRole.getUser_id()!=null && userRole.getUser_id()>0){
			clearUserRoleCache(userRole.getUser_id());
		}
		
	}

	@Cacheable(value="default",key="'UserRole-byid_' + #id")
	@Override
	public UserRole getUserRoleById(Long id) {
		return userRoleDAO.query(id);
	}

	@Cacheable(value="default",key="'userrolelistbyuserid_' + #userId")
	@Override
	public List<UserRole> getUserRoleListByUser(Long userId) {
		if(userId!=null && userId>0){
			return userRoleDAO.queryUserRoleList(userId);
		}
		
		return Collections.emptyList();
	}

	@CacheEvict(value="default",key="'userrolelistbyuserid_' + #userId")
	@Override
	public void clearUserRoleCache(Long userId) {
		// TODO Auto-generated method stub
	}
	
	@CacheEvict(value="default",key="'userrolelistbyuserid_' + #userId")
	@Override
	public void clearUserRole(Long userId) {
		if(userId!=null && userId>0){
			userRoleDAO.clearUserRole(userId);
		}
		
	}

	
	@Cacheable(value="default",key="'userrolelistbyuserid_' + #userId + #roleNames ")
	@Override
	public List<UserRole> getUserRoleList(String roleNames, Long userId) {
		if(userId>0l){
			return this.userRoleDAO.queryUserRoleList(roleNames, userId);
			
		}
		return Collections.emptyList();
	}

	@Cacheable(value="default",key="'userrolebyuserid_' + #userId + #roleNames ")
	@Override
	public UserRole getUserRoleByRoleName(String roleNames, Long userId) {
		List<UserRole> list = getUserRoleList(roleNames,userId);
		if(list!=null && list.size()>0){
			return list.get(0);
		}
		
		return null;
	}

	@Cacheable(value="default",key="'userrolelistbyuserid_' + #userId + '-roleid'+ #roleId ")
	@Override
	public List<UserRole> getUserRoleList2(Long roleId, Long userId) {
		return userRoleDAO.queryUserRoleList(roleId, userId);
	}
	
	

	@Override
	public boolean hasUsrRole(Long roleId, Long userId) {
		List<UserRole> urolelist = getUserRoleListByUser(userId);
		if(urolelist!=null && urolelist.size()>0){
			for(UserRole ur : urolelist){
				if(ur.getRole_id().equals(roleId)){
					return true;
				}
			}
		}
		
		return false;
	}

	
	
	

}
