package edu.ecompus.cas.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import edu.ecompus.cas.dao.AppDAO;
import edu.ecompus.cas.dao.CompanyAppDAO;
import edu.ecompus.cas.dao.CompanyDAO;
import edu.ecompus.cas.dao.FeedbackDAO;
import edu.ecompus.cas.dao.UserAppDAO;
import edu.ecompus.cas.entity.App;
import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.CompanyApp;
import edu.ecompus.cas.entity.Feedback;
import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserApp;
import edu.ecompus.cas.service.AppService;
import edu.ecompus.core.entity.Page;
import edu.ecompus.core.service.GenerateService;

/**
 * 应用服务层接口实现
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-3 下午5:29:26
 */
@Service("appService")
public class AppServiceImpl extends GenerateService implements AppService {
	/** 	 * 应用-DAO	 */
	@Autowired
	AppDAO appDao;
	
	/** 	 * 单位/学校应用-DAO	 */
	@Autowired
	CompanyAppDAO companyAppDAO;
	
	/** 	 * 用户应用-DAO	 */
	@Autowired
	UserAppDAO userAppDAO;

	/**
	 * 意见反馈-DAO
	 */
	@Autowired
	FeedbackDAO feedbackDAO;
	
	
	@Autowired
	CompanyDAO companyDao;
	
	@Override
	public CompanyApp getCompanyApp(Long id) {
		return companyAppDAO.query(id);
	}

	
	@Cacheable(value="default",key="'CompanyAppcachebyid_' + #id")
	@Override
	public CompanyApp getCompanyAppById(Long id) {
		return companyAppDAO.query(id);
	}
	
	
	@Override
	public List<App> getAppList(Page page) {
		return this.appDao.queryAppList(page);
	}
	

	@Override
	public List<CompanyApp> getCompanyApp(Company school, int apptype, int state) {
		if(school==null){
			return Collections.emptyList();
		}
		
		return this.companyAppDAO.queryCompanyApp(school.getId(), apptype, state);
	}


	@Override
	public List<UserApp> getUserApp(User user, Company school, int state) {
		if(user==null || school==null){
			return Collections.emptyList();
		}
		
		return this.userAppDAO.queryUserApp(user, school, state);
	}


	@Override
	public List<CompanyApp> getWeiboAppList(User user) {
		if(user==null){
			return Collections.emptyList();
		}
		
		if(user!=null && user.getSchool_id()==null){
			return Collections.emptyList();
		}
		
		Company school = companyDao.query(user.getSchool_id());
		
		List<CompanyApp> result = new ArrayList<CompanyApp>();
		//1.读取学校正常显示的所有微博APP
		List<CompanyApp> companyAppList = getCompanyApp(school,1,1);
		//2.读取用户所有的APP(包含隐藏APP)
		List<UserApp> userAppList = getUserApp(user, school, -1);
		//3.遍历过滤用户APP是否正常
		for(CompanyApp cpp : companyAppList){	//遍历学校App
			for(UserApp upp : userAppList){
				if(upp.getState()==2){	//用户显示的
					continue;
				}
				
				result.add(cpp);
			}
		}
		
		return result;
	}


	@Override
	public boolean isActivateApp(User user, CompanyApp cpp) {
		if(user==null || user.getSchool_id()!=null || cpp==null)
		{
			return false;
		}
		
		Company school = companyDao.query(user.getSchool_id());
		Long count = this.userAppDAO.countActivateApp(user, cpp, school);
		
		return count>0;
	}


	@Cacheable(value="default",key="'WeiAppListbyschool_' + #school")
	@Override
	public List<CompanyApp> getWeiAppList(Long school){
		if(school!=null && school>0){
			return this.companyAppDAO.queryCompanyApp(school, 2, 1);
		}
		
		return Collections.emptyList();
	}
	
	@CacheEvict(value="default",key="'WeiAppListbyschool_' + #schoolId")
	@Override
	public void clearWeiAppListCache(Long schoolId) {
		// TODO 清除校园微信应用缓存
		
	}
	
	@Override
	public List<CompanyApp> getWeiAppListNoCache(Long school) {
		if(school!=null && school>0){
			return this.companyAppDAO.queryCompanyApp(school, 2, 1);
		}
		
		return Collections.emptyList();
	}

	@Override
	public void activateApp(User user, CompanyApp cpp) {
		Company school = null;
		if(user!=null && user.getSchool_id()>0){
			 school = companyDao.query(user.getSchool_id());
		}
		
		UserApp upp = new UserApp();
		upp.setCreateDate(new Date());
		upp.setSchool(school);
		upp.setSchoolApp(cpp);
		upp.setState(1);
		upp.setUser(user);
		
		this.userAppDAO.create(upp);
	}

	@Cacheable(value="default",key="'appcachebykey_' + #id")
	@Override
	public App getAppById(Long id){
		if(id>0l){
			return appDao.query(id);
		}
		
		return null;
	}
	
	
	@Cacheable(value="default",key="'appcachebyclient_' + #clientId")
	@Override
	public App getByClientId(String clientId) {
		if(clientId!=null && !"".equals(clientId)){
			return appDao.queryClientByClientId(clientId);
		}
		return null;
	}

	
	/**
	 * 根据Id查询意见反馈
	 * @param id
	 * @return
	 */
	@Cacheable(value="default",key="'feedbackcachebykey_' + #id")
	@Override
	public Feedback getFeedbackById(Long id){
		if(id>0l){
			return feedbackDAO.query(id);
		}
		
		return null;
	}
	
	
	@CacheEvict(value="default",key="'feedbackcache'")
	@Override
	public Feedback addFeedback(Feedback feedback) {
		if(feedback!=null){
			feedbackDAO.create(feedback);
			return feedback;
		}
		return null;
	}
	
	
	@Override
	public List<Feedback> getFeedbackList(Long appid, int status, Page page) {
		return feedbackDAO.queryFeedbackList(appid, status, page);
	}

	@Cacheable(value="default",key="'feedbackcache'")
	@Override
	public List<Feedback> getFeedbackList(int status, Page page) {
		return feedbackDAO.queryFeedbackList(status, page);
	}

	@Override
	public Long countAppFeedback(Long appid, int status) {
		return feedbackDAO.countAppFeedback(appid, status);
	}


	

	
}
