/****************************************************************
文件名称:UserService.java                                                
项目名称: E-Compus CAS                                              
模块名称:                                                          
功能说明:                                                          
系统版本: 1.0                                                   
开发人员: 王树辉                                                                                                                                                  
开发时间: 2013-11-18 下午4:56:47                                     
相关文档:                                                          
*****************************************************************/
package edu.ecompus.cas.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.cas.entity.User;
import edu.ecompus.cas.entity.UserLoginLog;
import edu.ecompus.cas.entity.UserRole;
import edu.ecompus.core.common.exception.ML2DaoException;
import edu.ecompus.core.entity.Page;

/**
 * <b>用户</b> 服务层接口定义
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author wsh
 * @since Date： 2013-8-6 下午3:06:57
 */
@Transactional
public interface UserService {
	
	/**
	 * 创建用户
	 * @param company
	 */
	User addUser(User user);
	
	/**
	 * 变更用户
	 * @param user
	 */
	void updateUser(User user);
	
	/**
	 * 根据用户名查询用户信息
	 * @param userName
	 * @return
	 */
	User getUser(String userName, String nickName);
	
	/**
	 * 根据用户名查询用户信息
	 * @param userName
	 * @return
	 */
	User getUserByUserName(String userName);
	
	/**
	 * 根据用户名查询用户信息
	 * @param userName
	 * @return
	 */
	User getUserByUserNameNoCache(String userName);
	
	/**
	 * 清除根据用户名查询的用户信息缓存
	 * @param userName
	 */
	void clearUserByUserNameCache(String userName);
	
	/**
	 * 根据用户昵称查询用户
	 * 
	 * @param nickName
	 * @return
	 * @throws ML2DaoException
	 */
	User getUserByNickName(String nickName);
	
	/**
	 * 根据userId查询用户信息
	 * @param userId
	 * @return
	 */
	User getUserByUserId(Long userId);
	
	/**
	 * 根据用户编号查询用户
	 * @param ids
	 * @return
	 */
	List<User> getUserByIds(String ids);
	
	/**
	 * 综合查询用户列表
	 * @param username		用户昵称（NULL、空不为条件）
	 * @param enable		是否禁用（-1不为条件，1-正常,2-禁用）
	 * @param page			分页
	 * @return
	 */
	List<User> getUserList(String username, int enable, Page page);
	
	/**
	 * 增加登录日志
	 * @param ip
	 * @param userId
	 */
	void AddUserLoginLog(String ip, Long userId);
	
	/**
	 * 增加登录日志
	 * @param userLoginLog
	 * @return
	 */
	UserLoginLog addUserLoginLog(UserLoginLog userLoginLog);
	
	/**
	 * 统计登录次数
	 * @param userId	用户编号
	 * @return
	 */
	Long countLogin(Long userId);
	
	/**
	 * 查询用户角色列表
	 * @param user
	 * @return
	 * @throws ML2DaoException
	 */
	List<UserRole> getUserRoleList(User user);
	
	/**
	 * 根据学校编号的type类型读取用户列表
	 * @param type		类型（1-学生，2-老师，3-系统管理员。。。）
	 * @param schoolId	学校编号
	 * @return
	 */
	List<User> getUserList(int type, Long schoolId);
	
	
	/**
	 * 综合查询用户
	 * 
	 * @param keyword	  (NULL不为条件,模糊查询真实姓名与妮称)
	 * @param schoolId     (NULL不为条件,所属学校)
	 * @param enabled     (-1不为条件,状态1-正常,2-禁用)
	 * @param mobile      (NULL不为条件,手机号码)
	 * @param identity	  (NULL不为条件,模糊查询证件号码)
	 * @return
	 */
	List<User> getUserList(String keyword, Long schoolId, int enabled, String mobile, String identity, Page page);
}

