package edu.ecompus.cas.service;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.cas.entity.UserBind;


/**
 * 用户关系绑定 服务层 接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-7-10 下午5:19:38
 */
@Transactional
public interface UserBindService {
	/**
	 * 新建绑定
	 * @param userBind
	 * @return
	 */
	UserBind addUserBind(UserBind userBind);
	
	/**
	 * 更新绑定
	 * @param userBind
	 */
	void updateUserBind(UserBind userBind);
	
	/**
	 * 移除绑定
	 * @param userBind
	 */
	void deleteUserBind(UserBind userBind);
	
	/**
	 * 读取用户与学校的绑定
	 * @param userId		
	 * @param schoolId
	 * @return
	 */
	UserBind getUserBind(Long userId, Long schoolId);
	
	/**
	 * 根据userId与学校编号--清除绑定
	 */
	void clearUserBindByuserId(Long userId, Long schoolId);
	
	/**
	 * 根据微信OpenId与学校编号查询绑定用户
	 * @param winxinID
	 * @param schoolId
	 * @return
	 */
	UserBind getUserBindByWeixinId(String winxinID, Long schoolId);
	
	/**
	 * 清除微信缓存
	 */
	void clearUserBindByWeixinCache(String winxinID, Long schoolId);
	
	/**
	 * 根据微信OpenId与学校编号--清除绑定
	 */
	void clearUserBindByWeixinId(UserBind ub);
	
	/**
	 * 查询微信OpenId 绑定的用户信息(带缓存)
	 * @param openId		微信OpenId
	 * @return
	 */
	UserBind getUserBindByWXOpenId(String openId);
	
	/**
	 * 清除微信OpenId绑定用户缓存
	 * @param openId
	 */
	void clearUserBindByWXOpenId(String openId);
	
	/**
	 * 查询QQ 绑定的用户信息(带缓存)
	 * @param openId		微信OpenId
	 * @return
	 */
	UserBind getUserBindByQQ(String qq);
	
	/**
	 * 清除qq绑定用户缓存
	 * @param openId
	 */
	void clearUserBindByQQ(String qq);
	
	/**
	 * 查询WeiBo绑定的用户信息(带缓存)
	 * @param openId		微信OpenId
	 * @return
	 */
	UserBind getUserBindByWeiBo(String weibo);
	
	/**
	 * 清除WeiBo绑定用户缓存
	 * @param openId
	 */
	void clearUserBindByWeiBo(String weibo);
	
	/**
	 * 读取用户绑定
	 * @param userId		用户ID(-1不为条件)
	 * @param schoolId		学校ID(-1不为条件)
	 * @param winxinID		微信ID(NULl不为条件)
	 * @param qqId			QQID(NULL不为条件)
	 * @param sinaId		新浪ID(NULL不为条件)
	 * @return
	 */
	UserBind getUserBind(Long userId, Long schoolId, String winxinID, String qqId, String sinaId);
}
