package edu.ecompus.cas.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import edu.ecompus.cas.entity.Company;
import edu.ecompus.cas.entity.CompanyReg;
import edu.ecompus.core.entity.Page;

/**
 * <b>学校</b> 服务层接口定义
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-4-2 下午4:03:07
 */
@Transactional
public interface CompanyService {
	
	/**
	 * 创建学校
	 * @param company
	 */
	void creatCompany(Company company);
	
	/**
	 * 更新学校
	 * @param company
	 */
	void updateCompany(Company company);
	
	/**
	 * 查询学校
	 * @param companyId
	 * @return
	 */
	Company getCompanyById(Long id);
	
	/**
	 * 查询学校(带缓存）
	 * @param companyId
	 * @return
	 */
	Company getCompany(Long companyId);

	/**
	 * 获取所有学校数据
	 * @return
	 */
	List<Company> getCompanyList();
	
	/**
	 * 获取所有机构名录
	 * @return
	 */
	List<Company> getCompanyListByState0();
	/**
	 * 清除所有机构名录缓存
	 */
	void clearCompanyListByState0Cache();
	
	/**
	 * 条件查询[幼儿园]表数据
	 * @param company
	 * @param province
	 * @param city
	 * @param area
	 * @param status
	 * @return
	 */
	List<Company> getCompanyListByKey(String companyName, int status, String province, String city, String area, Page page);
	
	/**
	 * 查询机构
	 * @param keyword		机构名称、联系人、...
	 * @param district		省、市、区
	 * @param classify		-1不为条件，(1000-幼儿园 1001-小学 1002-初中 1003-高中 1004-职教)
	 * @param status		-1不为条件，（2000-公办园所,2001-民办园所,2002-合作园所,2003-早教机构）
	 * @param page			null不分页
	 * @return
	 */
	List<Company> getCompanyList(String keyword, String district, int classify, int status, Page page);
	
	/**
	 * 查询已存在的机构（所有状态）
	 * @param companyName
	 * @param province
	 * @param city
	 * @param area
	 * @return
	 */
	Company getExistsCompany(String companyName, String province, String city, String area);
	
	/**
	 * [幼教云后台管理系统]验证开通幼儿园数据
	 * @param keyword		关键词(NULL不为条件,学校名称,学校别名,联系人,电话,网址 ,地址,邮编,邮箱)
	 * @param status		状态(-1不为条件,0-全部
	 * @param page			分页
	 * @return
	 */
	List<Company> getCompanyListBySystem(String keyword, int status, Page page);
	
	/**
	 * 根据Id读取注册申请
	 * @param id
	 * @return
	 */
	CompanyReg getCompanyRegById(Long id);
	
	/**
	 * 添加机构注册申请
	 * @param companyReg
	 * @return
	 */
	CompanyReg addCompanyReg(CompanyReg companyReg);
	/**
	 * 更新注册申请
	 * @param companyReg
	 */
	void updateCompanyReg(CompanyReg companyReg);
	/**
	 * 删除注册申请
	 * @param companyReg
	 */
	void delCompanyReg(CompanyReg companyReg);
	
	/**
	 * 综合查询
	 * @param keyword	园所名称、联系人（NULL不为条件）
	 * @param type		机构类型（教育、金融、医疗、会计、法律、美容、婚庆、其它)
	 * @param province
	 * @param city
	 * @param page
	 * @return
	 */
	List<CompanyReg> getCompanyRegList(String keyword, int type,String province, String city, Page page);
}

