package edu.ecompus.cas.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 用户登录记录表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-11-18 上午11:24:46
 */
@Entity
@Table(name = "TAB_USER_USERLOGINLOG")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class UserLoginLog {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 1l; //主键
	
	/**
	 * 用户编号
	 */
	private Long userId;
	
	/**登录时间**/
	private Date loginDate;
	
	/**
	 * 登录IP
	 */
	private String loginIp;

	
	
	

}
