package edu.ecompus.cas.entity;

import java.util.Date;
import java.util.List;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 用户基础表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author Author：        <JannyShao>
 * Create Date：  <2013-6-24 上午9:46:14>
 * 
 * @Table(name = "TAB_USER")
 */
@Entity
@Table(name = "TAB_USER")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class User  {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键

//=================基础信息================================================
	 /**
     * 登陆用户名(登陆号)       db_column: username 
     */ 	
	private String username;
	
    /**
     * 用户密码       db_column: password 
     */ 	
	private String password;
	
	/**
	 * 真实姓名
	 */
	private String name;
	
	/**
	 * 昵称(小名)
	 */
	private String nickname;
	
	/**
     * 是否被禁用(1-正常,2-禁用)       db_column: enabled 
     */ 	
	private int enable = 1;
	
	/**
	 * 自我介绍
	 */
	private String introduction;
	
//=================头像照片================================================
	/**
	 * 用户头像
	 */
	private String userface;

//=================联系方式================================================
	/**
	 * QQ号码
	 */
	private String QQ;
	
	/**
	 * 邮箱
	 */
	private String email;                       // required; unique
	
	/**
	 * 移动号码(唯一?)
	 */
	private String mobile;
	/**
	 * 固定电话
	 */
	private String phoneNumber;
	
	/** 所在省  **/
	private String province; //省
	
	/** 所在市  **/
	private String city; //市
	
	/** 所在区  **/
	private String area; //市
	/**
	 * 所在地址/联系地址
	 */
	private String address;
	/**
	 * 邮编
	 */
	private String postcode;
	
	/**
	 * 性别1-男,2-女
	 */
	private int sex;
	
	/**
	 * 出生日期
	 */
	private Date birth;
	
	
	/**
	 * 民族
	 */
	private String nation;
	
	/**
	 * 籍贯(生出地)
	 */
	private String birthplace;
	
	/**
	 * 证件类型
	 * 1-大陆身份证,2-港澳台身份证,3-学生证,4-军官证,5-护照
	 */
	private int identityType = 1;
	
	/**
	 * 证件号码
	 */
	private String identity;
	
	/**
	 * 用户类型:::
	 * 1-学生:微博,以及未来推出学生可用的APP
	 * 2-老师:微博/学校后台,未来推出老师可用的APP
	 * 3-系统管理员:幼教园后台
	 * 4-代理用户
	 * ....**/
	private int type;
	
	
	/**
	 * 当前所在学校
	 * <b>school_id为NULL时，非入驻用户，不能登录幼教云
	 */
	private Long school_id;		
	
	
	/**
	 * 备注
	 */
	private String remark;
	
	//==========@Transient===========================
	/**
	 * 用户角色列表
	 */
	@Transient
	private List<UserRole> roles;
	
	/**
	 * 判断是否有权限
	 * @param roleId
	 * @return
	 */
	@Transient
	public boolean hasUsrRole(Long roleId) {
		if(roles!=null && roles.size()>0){
			for(UserRole ur : roles){
				if(ur.getRole_id().equals(roleId)){
					return true;
				}
			}
		}
		
		return false;
	}
	
}
