package edu.ecompus.cas.entity;

import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;




/**
 * 角色表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-6-25 下午4:36:27
 */
@Entity
@Table(name = "TAB_ROLE")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class Role  {
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
     * 角色名      ROLE_CLIENT, ROLE_TRUSTED_CLIENT
     */ 	
	private String name;
	
	/**
	 * 描述	 db_column: resume 	客户端/用户/管理员...
	 */
	private String resume;
	
	/**
	 * 0-普通角色
	 * 1-管理员角色
	 */
	private int byadmin = 1;
	
	/**
	 * NULL为系统角色
	 * 企业编号
	 */
	private Long companyId;
	
	//==========@Transient===========================
	/***
	 * 模块列表
	 */
	@Transient
	private Set<Module> modules;
	
	
}
