package edu.ecompus.cas.entity;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 学期表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-12-27 上午11:25:32
 */
@Entity
@Table(name="TAB_COMPANY_TERM")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class CompanyTerm implements Serializable {
	private static final long serialVersionUID = -4372021185853244843L;
	
	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**学期年份**/
	private String year; 
	
	/**学期，例如：fh(上半学期),sh(下半学期)**/
	private String term;
	
	/**
	 * 所属学校
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="school_id")
	private Company school;	
	
	/** 状态 1-当前学期，其他-历史学期**/
	private int state;
	
	/**
	 * 读取学期全称
	 * @return
	 */
	@Transient
	public String getYearTerm(){
		String _tmp = "";
		if(year!=null && !"".equals(year)){
			_tmp = year;
		}
		//TODO 上半学期与下半学期名称自定义
		if(term!=null && !"".equals(term)){
			if("sf".equals(term.toLowerCase())){
				_tmp = _tmp + "上半学期";
			}else{
				_tmp = _tmp + "下半学期";
			}
		}
		
		return _tmp;
	}
	
	
}
