package edu.ecompus.cas.entity;

import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * 单位(学校)应用表
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-9-3 下午2:42:34
 */
@Entity
@Table(name = "TAB_COMPANY_APP")
@Cache(usage = CacheConcurrencyStrategy.READ_WRITE)
public @Data class CompanyApp {
	
	@Id @GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id = 0l; //主键
	
	/**
	 * 所属学校
	 */
	private Long school_id;		
	
	/**
	 * 应用别名(示：WeiPhoto，WeiVideo...)
	 */
	private String appalias;
	
	/**
	 * 应用
	 */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name="app_id")
	private App app;
	
	/**
	 * 应用状态:1-启动,2-禁用(当此处为2时,所有单位里的用户,都禁用)
	 */
	private int state = 1;
	
	/**
	 * 创建日期
	 */
	private Date	createDate;

	/**
	 * 应用类型(学校设置,1-微博应用,2-微信应用)
	 */
	private int apptype = 1;
	
	/**
	 * 使用角色
	 * <li>null表示所有用户都适用的APP
	 * <li>单个角色适用
	 * <li>用逗号隔开的表示多个角色适用
	 * Long：ROLE_USER、ROLE_TEACHER、ROLE_MASTER、ROLE_HEAD,例如：2,4：：只适用于班主任与园长角色
	 */
	private String roleids;
	
	
}
