package edu.ecompus.cas.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.cas.dao.FeedbackDAO;
import edu.ecompus.cas.entity.Feedback;
import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
/**
 * <b>意见反馈表</b> 数据持久类 操作接口实现
 * 
 * 
 * @CopyRight CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2014-1-21 下午1:57:12
 */
@Repository
public class FeedbackDaoImpl extends ML2TemplateGenericDao<Feedback> implements
		FeedbackDAO {


	public FeedbackDaoImpl() {
		super(Feedback.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Feedback> queryFeedbackList(Long appid, int status, Page page) {
		StringBuffer sql = new StringBuffer("from Feedback where id>0 ");
		
		if(appid>0l){
			sql.append(" and app_id=").append(appid);
		}else if(appid==0l){
			sql.append(" and app_id=null");
		}
		
		if(status!=-1){
			sql.append(" and status=").append(status);
		}
		
		sql.append(" order by createDate desc");
		
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}

	@Override
	public Long countAppFeedback(Long appid, int status) {
		StringBuffer sql = new StringBuffer("select count(id) from Feedback where id>0");
		if(appid>0l){
			sql.append(" and app_id=").append(appid);
		}else if(appid==0l){
			sql.append(" and app_id=null");
		}
		
		if(status!=-1){
			sql.append(" and status=").append(status);
		}
		
		
		return (Long) this.queryForObject(sql.toString(),
				new Object[]{});
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Feedback> queryFeedbackList(int status, Page page) {
		StringBuffer sql = new StringBuffer("from Feedback where id>0 ");
		
		if(status!=-1){
			sql.append(" and status=").append(status);
		}
		
		sql.append(" order by createDate desc");
		
		if(page==null){
			return this.hibernateTemplate.find(sql.toString());
		}
		
		return this.queryForList("select count(*) " + sql.toString(), sql.toString(),
				new Object[] {}, page);
	}

}
