package edu.ecompus.cas.dao.impl;


import java.util.List;

import org.springframework.stereotype.Repository;

import edu.ecompus.cas.dao.CompanyDAO;
import edu.ecompus.cas.entity.Company;
import edu.ecompus.core.dao.impl.ML2TemplateGenericDao;
import edu.ecompus.core.entity.Page;
/**
 * <b>单位</b> 数据持久类 操作接口实现
 * 
 * 
 * CopyRright (c) 2013:   <紫悦新橙>
 * Project:               <数字化校园 >
 * Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * Comments:  <对此类的描述，可以引用系统设计中的描述>
 * JDK version used:      <JDK1.6> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2013-8-6 下午3:04:27
 */
@Repository
public class CompanyDaoImpl extends ML2TemplateGenericDao<Company> implements
		CompanyDAO {

	public CompanyDaoImpl() {
		super(Company.class);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Company> queryCompanyList() {
		return this.hibernateTemplate.find("from Company");
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Company> queryCompanyListByKey(String companyName, int status, String province, String city, String area, Page page) {
		StringBuffer sql = new StringBuffer("from Company where id>0 and classify=1000");
		if (companyName != null && !"".equals(companyName)) {
			sql.append(" and name like '%").append(companyName).append("%'");
		}
		if (status > -1) {
			sql.append(" and status = ").append(status);
		}
		if (province != null && !"".equals(province)) {
			sql.append(" and province = '").append(province).append("'");
		}
		if (city != null && !"".equals(city)) {
			sql.append(" and city = '").append(city).append("'");
		}
		if (area != null && !"".equals(area)) {
			sql.append(" and area = '").append(area).append("'");
		}
		
		sql.append(" order by createDate desc");
		
		logger.info(sql.toString());
		if(page==null){
			return this.hibernateTemplate.find(sql.toString(), new Object[]{});
		}
		
		return this.queryForList("select count(*) " + sql.toString(),
				sql.toString(), new Object[] {  }, page);
		
	}

	@Override
	public void creatCompany(Company company) {
		this.creatCompany(company);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Company> queryCompanyListBySystem(String keyword, int status,
			Page page) {
		StringBuffer sql = new StringBuffer("from Company where id>0");
		if(status!=-1){
			sql.append(" and status=").append(status);
		}
		
		if(keyword!=null && !"".equals(keyword)){
			sql.append(" and (name like '%").append(keyword).append("%'");
			sql.append(" 	or alias like '%").append(keyword).append("%'");
			sql.append(" 	or contact like '%").append(keyword).append("%'");
			sql.append(" 	or telphone like '%").append(keyword).append("%'");
			sql.append(" 	or website like '%").append(keyword).append("%'");
			sql.append(" 	or address like '%").append(keyword).append("%'");
			sql.append(" 	or postcode like '%").append(keyword).append("%'");
			sql.append(" 	or email like '%").append(keyword).append("%')");
		}
		
		sql.append(" order by createDate desc");
		
		return this.queryForList("select count(*) " + sql.toString(),
				sql.toString(), new Object[] {  }, page);
		
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Company> queryCompanyList(String keyword, String district,
			int classify, int status, Page page) {
		StringBuffer sql = new StringBuffer("from Company where id>0 ");
		if(keyword!=null && !"".equals(keyword)){
			sql.append(" and (name like '%").append(keyword).append("%'");
			sql.append(" 	or alias like '%").append(keyword).append("%'");
			sql.append(" 	or contact like '%").append(keyword).append("%'");
			sql.append(" 	or telphone like '%").append(keyword).append("%'");
			sql.append(" 	or website like '%").append(keyword).append("%'");
			sql.append(" 	or address like '%").append(keyword).append("%'");
			sql.append(" 	or postcode like '%").append(keyword).append("%'");
			sql.append(" 	or email like '%").append(keyword).append("%')");
		}
		
		if(classify!=-1){
			sql.append(" and classify = ").append(classify);
		}
		
		//状态 0-新申请 1-正常 2-注销
		if (status == -2) {
			sql.append(" and (status=0 or status=1 )");
		}else if(status ==-1){
			//所有
		}else{
			sql.append(" and status = ").append(status);
		}
		
		if(district!=null && !"".equals(district)){
			sql.append(" and (province = '").append(district).append("'");
			sql.append(" 	or city = '").append(district).append("'");
			sql.append(" 	or area = '").append(district).append("')");
		}
		
		sql.append(" order by createDate desc");
		
		logger.info(sql.toString());
		if(page==null){
			return this.hibernateTemplate.find(sql.toString(), new Object[]{});
		}
		
		return this.queryForList("select count(*) " + sql.toString(),
				sql.toString(), new Object[] {  }, page);
	}

}
