package edu.ecompus.cas.cache.memcached;

import java.util.concurrent.TimeoutException;

import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

import com.google.code.ssm.api.format.SerializationType;
import com.google.code.ssm.providers.CacheException;

/**
 * Memcached缓存
 * 
 * 
 * @CopyRight CopyRright (c) 2013: <紫悦新橙> Project: <数字化校园 > Module ID:
 *            <(模块)类编号，可以引用系统设计中的类编号> Comments: <对此类的描述，可以引用系统设计中的描述> JDK
 *            version used: <JDK1.6>
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since Date： 2015-2-4 下午5:32:00
 */
public class MemcachedCache implements Cache {

	private com.google.code.ssm.Cache cache;

	public com.google.code.ssm.Cache getCache() {
		return cache;
	}

	public void setCache(com.google.code.ssm.Cache cache) {
		this.cache = cache;
	}

	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return this.cache.getName();
	}

	@Override
	public Object getNativeCache() {
		// TODO Auto-generated method stub
		return this.cache;
	}

	@Override
	public ValueWrapper get(Object key) {
		// TODO Auto-generated method stub
		Object object = null;
		try {
			object = this.cache.get((String) key, SerializationType.JAVA);
		} catch (TimeoutException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (CacheException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return (object != null ? new SimpleValueWrapper(object) : null);
	}

	@Override
	public void put(Object key, Object value) {
		// TODO Auto-generated method stub
		try {
			this.cache.set((String) key, 86400, value, SerializationType.JAVA);
		} catch (TimeoutException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (CacheException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Override
	public void evict(Object key) {
		// TODO Auto-generated method stub
		try {
			this.cache.delete((String) key);
		} catch (TimeoutException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (CacheException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Override
	public void clear() {
		// TODO Auto-generated method stub
		try {
			this.cache.flush();
		} catch (TimeoutException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (CacheException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
